% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_bathurst1985.R
\name{n_bathurst1985}
\alias{n_bathurst1985}
\title{Compute grain roughness via Bathurst (1985)}
\usage{
n_bathurst1985(depth, grain, restrict = TRUE)
}
\arguments{
\item{depth}{flow depth (H) in meters. The original model was calibrated
for 0.102 m < H < 1.60 m.}

\item{grain}{grain size (d84) in millimeters. The original model was calibrated
for 113 mm < d84 < 740 mm.}

\item{restrict}{allows for function parameters to restrict certain values. Type bool. Default TRUE.}
}
\value{
Manning's n
}
\description{
\code{n_bathurst1985} calculate Manning's n using the Bathurst (1985) method
for estimating grain roughness
}
\examples{
# Result: Manning's n of 0.085
n_bathurst1985(0.15,250)

# Result: Manning's n of 0.036
n_bathurst1985(0.8,120)

# Result: Manning's n of 0.056
n_bathurst1985(1.32,600)

# Result: Grain must be within 113 and 740 mm.
n_bathurst1985(1.32,50)

}
\references{
Bathurst, J. C. 1985. Flow Resistance Estimation in Mountain Rivers. Journal
of Hydraulic Engineering. American Society of Civil Engineers, Vol. 111 (4), pp. 625-643.
}
