% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_uptake_curve.R
\name{plot_uptake_curve}
\alias{plot_uptake_curve}
\title{Deuterium uptake curve}
\usage{
plot_uptake_curve(
  uc_dat,
  theoretical = FALSE,
  fractional = FALSE,
  uncertainty_type = "ribbon",
  log_x = TRUE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{uc_dat}{data produced by \code{\link{calculate_kinetics}} 
or \code{\link{calculate_peptide_kinetics}} or \code{\link{create_kinetic_dataset}}
functions}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}

\item{uncertainty_type}{type of uncertainty presentation, possible values:
"ribbon", "bars" or "bars + line"}

\item{log_x}{\code{logical}, indicator if the X axis values 
are transformed to log10}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot deuterium uptake curve for selected peptides
}
\details{
The function \code{\link{plot_uptake_curve}} generates
the deuterium uptake curve for selected peptides 
from selected protein.
On X-axis there are time points of measurements. On Y-axis there
is deuterium uptake in selected form. The combined and propagated
uncertainty can be presented as ribbons or error bars.
}
\examples{
uc_dat <- calculate_kinetics(alpha_dat, protein = "db_eEF1Ba",
                             sequence = "GFGDLKSPAGL", 
                             state = "Alpha_KSCN",
                             start = 1, end = 11,
                             time_0 = 0, time_100 = 1440)
plot_uptake_curve(uc_dat = uc_dat, 
                  theoretical = FALSE, 
                  fractional = TRUE)
                
}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_kinetics}}
\code{\link{calculate_peptide_kinetics}}
\code{\link{create_kinetic_dataset}}
}
