% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autophase.R
\name{hapiAutoPhase}
\alias{hapiAutoPhase}
\title{Automatic inference of haplotypes}
\usage{
hapiAutoPhase(gmt, code = "atcg")
}
\arguments{
\item{gmt}{a dataframe of genotype data of gamete cells}

\item{code}{a character indicating the code style of genotype data. 
One of \code{'atcg'} and \code{'01'}. Default is \code{'atcg'}}
}
\value{
a dataframe of inferred consensus haplotypes
}
\description{
Automatic inference of haplotypes
}
\examples{
ref <- sample(c('A','T'),500, replace=TRUE)
alt <- sample(c('C','G'),500, replace=TRUE)

gmt <- data.frame(chr=rep(1,500), pos=seq_len(500),
    ref=ref, alt=alt, gmt1=ref, gmt2=alt, gmt3=ref,
    gmt4=ref, gmt5=c(alt[1:250], ref[251:500]),
    stringsAsFactors = FALSE)
    
hapOutput <- hapiAutoPhase(gmt=gmt, code='atcg')
}
\author{
Ruidong Li
}
