% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HighestMedianRules.R
\name{rankings}
\alias{rankings}
\title{Rankings}
\usage{
rankings(
  grades,
  scale = c(),
  names = row.names(grades),
  return_distance = FALSE,
  rounds = TRUE
)
}
\arguments{
\item{grades}{A voting profile, i.e. a matrix with the shares of grades of each candidate on each row, from the lowest grade to the highest.}

\item{scale}{A numeric vector containing the values of the scale of grades. Default to c((floor(-length(grades)/2)+1):(length(grades)+floor(-length(grades)/2))).}

\item{names}{String vector, each string to be printed in case print = TRUE. Defaults to c().}

\item{return_distance}{If TRUE, returns the Kendall distance between the rules (using AllKendall) instead of the matrix of scores. Default to FALSE.}

\item{rounds}{If TRUE, rounds the scores (to 3 digits for highest median rules and 2 digits for range voting). Default to TRUE.}
}
\value{
A character matrix with as many rows as elements of \code{grades}, and with the name, gauge and scores (according to five different rules) on each row.
}
\description{
Returns a matrix with the scores of candidates sorted in decreasing order of score mj, for the five following voting rules (with k=0.5): mj, d, s, n, mean. See function 'score' for more details.
}
\examples{
rankings(elec2012, scale=-2:4)
}
