% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpg_analysis.R
\name{cpg_analysis}
\alias{cpg_analysis}
\title{CpG Analysis}
\usage{
cpg_analysis(
  list = FALSE,
  count,
  cpg_file,
  nuc_file,
  palette = "Set3",
  plot = "none"
)
}
\arguments{
\item{list}{"boolean of whether input is a list of groups. Default = FALSE."}

\item{count}{"numeric value for the number of files included in your list}

\item{cpg_file}{"file names or list of files names for your CpGcount.txt files. This is defined in cpg_analysis.sh"}

\item{nuc_file}{"file names or list of files names for your nucOutput_gc.txt files. This is defined in cpg_analysis.sh"}

\item{palette}{"if choosing to plot, the RColorBrewer palette you would like to be applied to your plot"}

\item{plot}{"one of three choices depending on what output you would like: 'none' for no plot, 'ratio' for observed/expected ratios, 'gc_percent' for GC\%"}
}
\value{
ggplot object or tibble if plot="none"
}
\description{
Compute observed/expected CpG ratio and GC\% for regions of interest
}
\details{
The function reads in a nucOutput_gc and CpGcount text file
The function uses the nucOutput_gc and CpGcount file to calculates observed/expected ratio and GC\%.
The function allows the option to plot the distribution of these values in ggplot2
}
\examples{
#load external data

gain_6hr_CpG <- system.file(package = "HodgesTools", "extdata",
"cov5root_6hr_gain.CpGcount.txt")
gain_12hr_CpG <- system.file(package = "HodgesTools", "extdata",
 "cov5root_12hr_gain.CpGcount.txt")
gain_6hr_nuc <- system.file(package = "HodgesTools", "extdata",
 "cov5root_6hr_gain.nucOutput_gc.txt")
gain_12hr_nuc <- system.file(package = "HodgesTools", "extdata",
"cov5root_12hr_gain.nucOutput_gc.txt")

#Make a density plot of GC\% values for a list of two region of interest files
cpg_analysis(list = TRUE, count = 2, cpg_file = list(gain_6hr_CpG, gain_12hr_CpG),
nuc_file= list(gain_6hr_nuc, gain_12hr_nuc), palette = "Set3", plot ="gc_percent")

#Make a density plot of observed/expected values for a single set of regions of interest
cpg_analysis(list = FALSE, cpg_file = gain_6hr_CpG,
nuc_file = gain_6hr_nuc, palette = "Set3", plot ="ratio")
}
\author{
Lindsey Guerin
}
