% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_boundary_mtpi.R
\name{get_boundary_mtpi}
\alias{get_boundary_mtpi}
\title{Generate modified mTPI Design Decision Boundary}
\usage{
get_boundary_mtpi(
  target,
  ncohort,
  cohortsize,
  eps1 = 0.05,
  eps2 = 0.05,
  a = 1,
  b = 1,
  cutoff.eli = 0.95,
  tox.control = FALSE,
  cut.tox = 0.8,
  esc.control = FALSE,
  cut.esc = 0.5
)
}
\arguments{
\item{target}{target toxicity rate}

\item{ncohort}{the total number of cohorts}

\item{cohortsize}{the cohort size}

\item{eps1}{modified Toxicity Probability Interval (mTPI) design parameter epsilon1. Default: 0.05}

\item{eps2}{modified Toxicity Probability Interval (mTPI) design parameter epsilon2. Default: 0.05}

\item{a}{Beta prior shape parameter 1. Default: 1}

\item{b}{Beta prior shape parameter 2. Default: 1}

\item{cutoff.eli}{Posterior probability cutoff of eliminating dose due to unacceptable toxicity. Default: 0.95}

\item{tox.control}{indicator of whether to perform toxicity control. If \code{TRUE}, change "stay"
to "deescalation" if the posterior probability of DLT rate greater than
\code{target+eps2} is greater than the toxicity control cutoff \code{cut.tox}}

\item{cut.tox}{toxicity control cutoff. Default: 0.8}

\item{esc.control}{indicator of whether to perform escalation control. If \code{TRUE}, change decision
of "escalation" to "stay" if the posterior probability of DLT rate less than
\code{target-eps1} is greater than the escalation control cutoff \code{cut.esc}}

\item{cut.esc}{escalation control cutoff. Default: 0.5}
}
\value{
This function returns the table of escalation and deescalation boundaries.
}
\description{
Generate dose escalation and deescalation boundaries of modified Toxicity Probability Interval (mTPI) design
with overdose control.
}
\examples{
get_boundary_mtpi(target=0.30, ncohort=10, cohortsize=3)

}
