% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fooTransp.R
\name{ViscTD}
\alias{ViscTD}
\title{Dynamic Viscosity, Function of Temperature and Density}
\usage{
ViscTD(Temp, D, digits = 9)
}
\arguments{
\item{Temp}{Temperature [ K ]}

\item{D}{Density [ kg m-3 ]}

\item{digits}{Digits of results (optional)}
}
\value{
The Dynamic viscosity: [ Pa s ] and an Error Message (if an error occur)
}
\description{
The function \code{ViscTD(Temp,D,digits=9)} computes the Dynamic Viscosity
     [ Pa s ] for given Temp [K] and D [kg/m3], returning the computed
     viscosity and an error message, if an error occur. \link{errorCodes}
}
\details{
This function calls a Fortran DLL that solves the equations developed by
    the International Association for the Properties of Water and Steam, valid from 
    the triple point to the pressure of 1000 MPa and temperature of 1173.15K.
     \url{https://iapws.org/relguide/viscosity.html}
}
\examples{
Temp <- 500.
D <- 838.025
Vis <- ViscTD(Temp,D)
Vis

}
