% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individualized-Dynamic-Latent-Factor-Model.R
\name{generate_data}
\alias{generate_data}
\title{Generate data for simulation}
\usage{
generate_data(n_patients, n_var, time, idx_x, idx_y, rank, k, N)
}
\arguments{
\item{n_patients}{the number of patients}

\item{n_var}{the number of X variables}

\item{time}{maximum time}

\item{idx_x}{indices for the x data, a sparse matrix}

\item{idx_y}{indices for the y data, a sparse matrix}

\item{rank}{rank for the random matrices}

\item{k}{spline smoothness}

\item{N}{number of knots in the splineS}
}
\value{
A list is returned, containing output_x and output_y as sparse matrices of x_data and y_data, spline knots, individualized dynamic latent factor, shared latent factor for X and Y.
}
\description{
This function generates simulated data in multiple time series with heterogeneity and non-stationarity.
It includes 3 settings in Setion 5.3.
}
\examples{
library(splines)
#if (!require("BiocManager", quietly = TRUE))
#install.packages("BiocManager")
#BiocManager::install("SparseArray")
library(SparseArray)

I <- 3
J <- 5
time <- 1000
R <- 3
k <- 3
N <- 300
idx_x <- randomSparseArray(c(I, J, time), density=0.8)
idx_y_train <- randomSparseArray(c(I, 1, time), density=0.2)
idx_y_test <- randomSparseArray(c(I, 1, time), density=0.2)
generate_data(I, J, time, idx_x, idx_y_train, R, k, N)
}
\references{
Zhang, J., F. Xue, Q. Xu, J. Lee, and A. Qu. "Individualized dynamic latent factor model for multi-resolutional data with application to mobile health." Biometrika (2024): asae015.
}
