% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drawre.R
\name{drawre}
\alias{drawre}
\title{Extraction of independent rainfall events from a sub-daily time series}
\usage{
drawre(Time_series,IETD,Thres)
}
\arguments{
\item{Time_series}{A dataframe. The first column contains the time and day of a rainfall pulse and the second one the depth
of rainfall in each time step. The date must be as POSIXct class.}

\item{IETD}{The minimum rainless period or dry period (hours) to be considered between two independent rainfall events.}

\item{Thres}{A rainfall depth threshold to define slight rainfall events (default value 0.5).}
}
\value{
A list with a dataframe, named Rainfall_Characteristics, and a sublist, named Rainfall_Events, is provided.
Rainfall_Characteristics contains the main information of each extracted rainfall event such as event number,
the beginning and end of the event, duration (in hours), total rainfall depth, and average intensity (total rainfall depth/duration).
Rainfall_Events contains several dataframes with the values of rainfall pulses of each extracted rainfall event.
The first dataframe in Rainfall_Events corresponds to the first event in Rainfall_Characteristics, the second
dataframe in Rainfall_Events corresponds to the second event in Rainfall_Characteristics, and so on.
}
\description{
This function draws rainfall events from a sub-daily rainfall time series based on the inter-event
time definition (IETD) method and computes the event characteristics such as duration, total rainfall depth, and
intensity. The function allows slight rainfall events to be characterized, which are, in turn, not considered in
the extraction of rainfall events.
}
\details{
IETD is defined as the minimum dry or rainless period between two independent events. This time interval is
applied to a continuous time series: if two groups of consecutive pulses of rainfall are separated by a rainless period
longer than or equal to IETD, they are considered as two independent rainfall events; otherwise, these two groups are categorized
as belonging to the same event \insertCite{Restrepo-Posada1982,Adams2000}{IETD}. A rainless period between two independent
events is known as inter-event time (b) and by definition b>= IETD. A rainfall event whose rainfall pulses are lower than the
threshold Thres is characterized as a slight rainfall event.
}
\note{
This function does not accept missing values in the sub-daily rainfall time series.
}
\examples{
\donttest{drawre(Time_series=hourly_time_series,IETD=5,Thres=0.5)}
}
\references{
\insertAllCited{}
}
\author{
Luis F. Duque <lfduquey@gmail.com> <l.f.duque-yaguache2@newcastle.ac.uk>
}
