% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_add_graphs.R
\name{data_add_graphs}
\alias{data_add_graphs}
\title{Add Graphs to IFC_data Object}
\usage{
data_add_graphs(obj, graphs, adjust_graph = TRUE, ...)
}
\arguments{
\item{obj}{an `IFC_data` object extracted by ExtractFromDAF(extract_features = TRUE) or ExtractFromXIF(extract_features = TRUE).}

\item{graphs}{a list of graph(s) to add to obj. Each element of this list will be coerced by \code{\link{buildGraph}}.}

\item{adjust_graph}{whether to try to adjust graph(s) when possible. Default is TRUE.\cr
-TRUE, graph(s) will be kept if possible using only regions, pops it depends that can be found in 'obj',\cr
-FALSE, graph(s) will be kept only if all features, regions, pops it refers to are found in 'obj',\cr
-NA, is not allowed and will throw an error.}

\item{...}{Other arguments to be passed.}
}
\value{
an IFC_data object with graphs added.
}
\description{
Adds graphs to an already existing `IFC_data` object.
}
