#'Determine the pair by pair effects that are important for the analysis.
#'@description Selects, pair by pair, the effect of S.S. on L.S.
#'@usage SelectEffectivenessOfSolution(EffectivenessOfSolution)
#'@param EffectivenessOfSolution Output generated by the function  `EffectivenessOfSolution`

#'@author Germano Leao Demolin-Leite (Instituto de Ciencias Agrarias da UFMG) \cr
#' Alcinei Mistico Azevedo (Instituto de Ciencias Agrarias da UFMG)
#'@return Returns a vector with logical values demonstrating the
#'interactions considered important for the analysis.

#'@examples
#\dontrun{
#' data("DataLossSource")
#' ChisqTest_Distribution(DataLossSource)
#'
#' data("DataSolutionSource")
#' ChisqTest_Distribution(DataSolutionSource)
#'
#' data("DataDefoliation")
#' data("DataDamage")
#'
#' DataResult<-cbind(DataDefoliation,DataDamage$D.L.S.2,DataDefoliation,
#' DataDamage$D.L.S.4,DataDefoliation)
#' ResultLossSource<-LossSource(DataLoss = DataLossSource,DataResult =DataResult,
#' Cols=c(1,3,5),verbose=TRUE)
#'
#' EOS<-EffectivenessOfSolution(DataLossSource =DataLossSource,
#'                             DataSolutionSource =DataSolutionSource,
#'                             ResultLossSource = ResultLossSource)
#'
#' EOS
#' #Put: y and y
#' # ID=SelectEffectivenessOfSolution(EOS)
#' ID<-c(FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,
#' FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE)

#' ResultSolutionSource<-SolutionSource(SolutionData =DataSolutionSource,Production =DataResult,
#'                                     EffectivenessOfSolution =EOS ,Id = ID,Verbose = TRUE  )
#' ResultSolutionSource
#'
#' # Put: y,n,y,n,y,n and y
#' # ReductionAbundance(ResultSolutionSource,ResultLossSource,
#' #                  EffectivenessOfSolution=EOS)
#'
#' ###################################################
#' EOSDamage<-EffectivenessOfSolution(DataLossSource =DataDamage,
#'                                   DataSolutionSource =DataSolutionSource,
#'                                   ResultLossSource = NULL)
#'
#'
#' EOSDamage
#'
#' # Put: y, n and y
#' #ReductionDamage(ResultSolutionSource,LossSource=DataDamage,
#' #                EffectivenessOfSolution=EOSDamage)
# }
#'

#'@seealso  \code{\link{EffectivenessOfSolution}} ,  \code{\link{SolutionSource}}  ,  \code{\link{LossSource}}
#'@importFrom stats lm
#'@export




SelectEffectivenessOfSolution=function(EffectivenessOfSolution){
  ES=Es=EffectivenessOfSolution
  id=ES[,3]>0
  ID=NULL
  for(i in 1:nrow(Es)){


    #'@examples
    #\dontrun{
    #' data("DataLossSource")
    #' ChisqTest_Distribution(DataLossSource)
    #'
    #' data("DataSolutionSource")
    #' ChisqTest_Distribution(DataSolutionSource)
    #'
    #' data("DataDefoliation")
    #' data("DataDamage")
    #'
    #' DataResult<-cbind(DataDefoliation,DataDamage$D.L.S.2,DataDefoliation,
    #' DataDamage$D.L.S.4,DataDefoliation)
    #' ResultLossSource<-LossSource(DataLoss = DataLossSource,DataResult =DataResult,
    #' Cols=c(1,3,5),verbose=TRUE)
    #'
    #' EOS<-EffectivenessOfSolution(DataLossSource =DataLossSource,
    #'                             DataSolutionSource =DataSolutionSource,
    #'                             ResultLossSource = ResultLossSource)
    #'
    #' EOS
    #' #Put: y and y
    #' # ID<-SelectEffectivenessOfSolution(EOS)
    #' ID<-c(FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,
    #' FALSE,FALSE,FALSE,TRUE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE,FALSE)

    #' ResultSolutionSource<-SolutionSource(SolutionData =DataSolutionSource,Production =DataResult,
    #'                                     EffectivenessOfSolution =EOS ,Id = ID,Verbose = TRUE  )
    #' ResultSolutionSource
    #'
    #' # Put: y,n,y,n,y,n and y
    #' # ReductionAbundance(ResultSolutionSource,ResultLossSource,
    #' #                  EffectivenessOfSolution=EOS)
    #'
    #' ###################################################
    #' EOSDamage<-EffectivenessOfSolution(DataLossSource =DataDamage,
    #'                                   DataSolutionSource =DataSolutionSource,
    #'                                   ResultLossSource = NULL)
    #'
    #'
    #' EOSDamage
    #'
    #' # Put: y, n and y
    #' #ReductionDamage(ResultSolutionSource,LossSource=DataDamage,
    #' #                EffectivenessOfSolution=EOSDamage)
    # }
    #'

    if(id[i]==TRUE){
      res=as.matrix(Es[i,])

      print(paste0(res[1]," VS ",res[2], ": ES=",res[3]))
      bk=readline(prompt = "Do you want to consider this combination? (y/n)? ")
      ID=c(ID,bk)

    }

    if(id[i]==FALSE){
      ID=c(ID,"n")
  }
}
  ID=ID=="y"

  ID
}
