% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hetero.R
\name{hetero}
\alias{hetero}
\title{Heterogeneity Evaluation}
\usage{
hetero(
  data,
  use_cefn = TRUE,
  rep = NULL,
  irre = NULL,
  phi_min = NULL,
  phi_max = NULL,
  sq_em_tol = 1e-04,
  fdr.level = NULL,
  sample_size = NULL
)
}
\arguments{
\item{data}{A dataset which is constructed by pairs of coefficient
values \eqn{ \beta } and standard errors \eqn{ se(\beta)}.}

\item{use_cefn}{A boolean, denoting whether to use CEFN prior. If the value is TRUE,
CEFN prior is used, else, META prior is applied. The default value is TRUE.}

\item{rep}{A vector, denoting all the \eqn{k^2} (under CEFN prior) or \eqn{r} (under META prior) values constructing the reproducible signals. If not specified,
the default one is c(0.105,0.260,0.369), which corresponds to the several prior values satisfy that
\eqn{Pr(\beta_{i,1}, \beta_{i,2} have a same sign)=0.99, 0.975, 0.95} for CEFN prior.}

\item{irre}{A vector, denoting all the \eqn{k^2} or \eqn{r} values constructing the irreproducible signals. If not specified,
the default one is c(2.198, 3.636, 6.735), which corresponds to the several prior values satisfy that
\eqn{Pr(\beta_{i,1}, \beta_{i,2} have a same sign)=0.75, 0.70, 0.65} for CEFN prior.}

\item{phi_min}{A value which determines the maximum \eqn{phi}. If not specified, will be constructed
from the input datasets.}

\item{phi_max}{A value which determines the minimum \eqn{phi}. If not specified, will be constructed
from the input datasets.}

\item{sq_em_tol}{A small, positive scalar that determines when iterations should be terminated in squarem algorithm.
The default value is \eqn{1e-4}.}

\item{fdr.level}{The user-defined rejection level for false discovery rate.}

\item{sample_size}{The user-defined sample size.}
}
\value{
A list with the following components:
\item{gridweight}{ The final optimal weight vector evaluated on each grid point.}
\item{ind_prob}{ A matrix denoting the converged probability for each individual being inside the
three different groups, namely, the null, the reproducible and the irreproducible group.}
\item{est_prop}{ The estimated proportion value for the three different groups, namely, the null,
the reproducible and the irreproducible group.}
\item{lfdr}{ The local false discovery rate based on the null hyppthesis of
unit belonging to \eqn{H_R}, reproducible group. \eqn{lfdr=1-Pr(H_R)}}
\item{significant}{ If fdr.level is specified, a significant object recording
True or False will be returned }
}
\description{
Evaluating the overall and individually heterogeneity and reproducibility
for the given individuals(units) shared in different replicates.
}
\examples{
data("heterodata")
\donttest{
hetero.out<-hetero(heterodata,fdr.level=0.05)
names(hetero.out)
print(hetero.out$est_prop)
}

## for CRAN check
hetero.out<-hetero(heterodata[1:100,],fdr.level=0.05)


}
