% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipv_est.R
\name{ipv_est}
\alias{ipv_est}
\title{IPV estimation}
\usage{
ipv_est(
  dat,
  name,
  include_raw = TRUE,
  include_lav = TRUE,
  include_xarrow = TRUE,
  id = "id",
  value.var = "value",
  ...
)
}
\arguments{
\item{dat}{data frame; raw data (see details)}

\item{name}{character; name of the overall construct or test that comprises
all items used}

\item{include_raw}{logical; should raw estimates of factor loadings be
included in the output?; defaults to TRUE}

\item{include_lav}{logical; should lavaan objects of the fitted models be
included in the output?; defaults to TRUE}

\item{include_xarrow}{logical; should an object for the drawing of arrows in
nested plots be returned?; defaults to TRUE}

\item{id}{character; name of the case identifying variable in long format;
defaults to "id"}

\item{value.var}{character; name of the variable in long format that contains
measurement values; defaults to "value"}

\item{...}{further arguments passed to lavaan::cfa (or one step further to
lavaan::lavOptions).}
}
\value{
list; \code{$est} includes the center distances and all necessary
  input for the IPV chart functions, \code{$est_raw} includes the factor
  loadings and latent correlations, \code{$lav} includes the fitted models
  (class: \code{lavaan}), \code{$xarrow} includes a data frame for arrows
  between facets in nested charts, that can be passed on directly to
  \code{nested_chart}; by default, all three of these elements are provided.

  \code{$xarrow} includes only those cases, where the estimate of the latent
  correlation between facets exceeds the estimate of the latent correlation
  between their respective tests, as recommended by the original authors.
}
\description{
IPV estimation
}
\details{
the data given to \code{dat} can be either in long or in wide
  format.

  If they are in wide format, they have to conform to the following rules: *
  no additional variables / columns * variables are named according to the
  following pattern: \code{"test_facet_item"}. * If there is only one test in
  the data, the pattern is "facet_item". For tests without facets in a larger
  dataset also comprising tests with items, the pattern is "test_item". *
  Variable names have to be unique. Item names have to be unique at the level
  of the test (not only at the level of the facet) See example

  If they are in long format, they have to include the columns "test",
  "facet", and "item", as well as a case identifying variable (\code{id}) and
  the measurement variable (\code{value.var}).
}
\examples{
# An IPV that comprises the honesty/humility and the agreeableness factor of
# the HEXACO. Estimation takes some time.
\dontrun{res <- ipv_est(
  HEXACO[ ,grep("^H|^A", names(HEXACO))],
  "HA")
nested_chart(res)}

# Customize call to lavaan::cfa via ellipsis to treat missing data and use long format
# Estimation takes some time.
\dontrun{HEXACO_long <- reshape2::melt(
  cbind(id = row.names(HEXACO)[1:1000],
  HEXACO[1:1000,1:240]),
 id.vars = "id")
HEXACO_long$test <- substr(HEXACO_long$variable, 1, 1)
HEXACO_long$facet <- substr(HEXACO_long$variable, 3, 6)
HEXACO_long$item <- substr(HEXACO_long$variable, 8, 13)
HEXACO_long$variable <- NULL
head(HEXACO_long)
res <- ipv_est(
  HEXACO_long[HEXACO_long$test \%in\% c("H", "A"), ],
  name = "HA", missing = "fiml")}


}
