% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sim_ARDS_Win_Probability.R
\name{Sim_ARDS_Win_Probability}
\alias{Sim_ARDS_Win_Probability}
\title{Provides operating characteristics for a group sequential design using the I-SPY ARDS hierarchical composite ranked endpoint and gating strategy with gating strategy and Bayesian Wilcoxon Rank-Sum test.}
\usage{
Sim_ARDS_Win_Probability(
  CONTROL_TRUTH,
  CONTROL_VENT_DENSITY_NON_0_28,
  CONTROL_ADVANCED_DISTRIBUTION_NO_VENT,
  CONTROL_ADVANCED_DISTRIBUTION_VENT,
  TREATMENT_TRUTH,
  N_LOOK,
  cut_Wilcox,
  cut_gating,
  SAFETY_BOUND,
  Futility_BOUND,
  cut_AR,
  Num_Sims
)
}
\arguments{
\item{CONTROL_TRUTH}{List containing control simulation parameters for (1) Mortality, (2) Ventilator day distributions in survivors, and (3) advanced respiratory days in survivors.}

\item{CONTROL_VENT_DENSITY_NON_0_28}{Nonparametric density estimate of ventilator days between 1 and 27 days for control participants who do not die in 28 days.}

\item{CONTROL_ADVANCED_DISTRIBUTION_NO_VENT}{Nonparametric density estimate of advanced respiratory days between 1 and 28 days for control participants who do not die in 28 days and are never ventilated.}

\item{CONTROL_ADVANCED_DISTRIBUTION_VENT}{Nonparametric density estimate of advanced respiratory days between 1 and 28 days for control participants who do not die in 28 days and are never ventilated.}

\item{TREATMENT_TRUTH}{List containing treatment simulation parameters for (1) Mortality, (2) Ventilator day distributions in survivors, and (3) advanced respiratory days in survivors.}

\item{N_LOOK}{Sample size at interim looks}

\item{cut_Wilcox}{Superiority cutoffs for Bayesian Wilcoxon.}

\item{cut_gating}{Superiority cutoffs for Frequentist 1-sided Fisher test.}

\item{SAFETY_BOUND}{Safety threshold for a mortality increase in treatment participants.}

\item{Futility_BOUND}{Bounds for stopping for futility based on Bayesian Wilcoxon.}

\item{cut_AR}{Windows for AR truncation. Randomization probabilities are truncated between .5-cut_AR and .5+cut_AR.}

\item{Num_Sims}{Number of Simulations to run.}
}
\value{
A list containing the true simulation scenario, the design parameters, and the operating characteristics of the design. Operating characteristics include the graduation probability (i.e. power), the sample size distribution, and the joint distribution of graduation and sample size.
}
\description{
Provides operating characteristics for a group sequential design using the I-SPY ARDS hierarchical composite ranked endpoint and gating strategy with gating strategy and Bayesian Wilcoxon Rank-Sum test.
}
\examples{
####Set up simulation scenario example
##These are example nonparametric densities for ventilator days
##and advanced respiratory day distributions conditional on ventilation
## load("CONTROL_ADVANCED_DISTRIBUTION_NO_VENT.rda")
## load("CONTROL_ADVANCED_DISTRIBUTION_VENT.rda")
## load("CONTROL_VENT_DENSITY_NON_0_28.rda")
library(DFBA)
###Additional simulation parameters in control arm
Prob_Death=.25
P_Vent_0 = .48
P_Vent_28 = .05
P_ADVANCED_0_NO_VENT = .31
P_ADVANCED_0_VENT = .62
###Treatment Parameters
Prob_Death_Treatment = Prob_Death-.05
P_Vent_28_Treatment = P_Vent_28-.01
P_Vent_0_Treatment = P_Vent_0 + .1
CHANGE_MEAN_VENTILATION_TREATMENT = -2
P_ADVANCED_0_NO_VENT_Treatment = P_ADVANCED_0_NO_VENT + .1
CHANGE_MEAN_ADVANCED_TREATMENT_NO_VENT = -2
P_ADVANCED_0_VENT_Treatment = P_ADVANCED_0_VENT + .1
CHANGE_MEAN_ADVANCED_TREATMENT_VENT = -2
###Put all the parameters in a list
CONTROL_TRUTH = as.list(rep(NA,8))
names(CONTROL_TRUTH)=c("Probability of Death","Prob Vent at day 28 in survivors",
"Prob Vent for 0 days in survivors",
"Nonparametric density estimate of day 1-27 ventilation day in survivors",
"Prob of 0 day advanced respiratory support in
  non-ventilated surviving participants",
"Nonparametric density estimate of day 1-28 advanced respiratory
 days in non-ventilated surviving participants",
"Prob of 0 day advanced respiratory support in
 ventilated surviving participants",
"Nonparametric density estimate of day 1-28 advanced
respiratory days in ventilated surviving participants")
CONTROL_TRUTH[[1]] = Prob_Death
CONTROL_TRUTH[[2]] = P_Vent_28
CONTROL_TRUTH[[3]] = P_Vent_0
CONTROL_TRUTH[[4]] = CONTROL_VENT_DENSITY_NON_0_28
CONTROL_TRUTH[[5]] = P_ADVANCED_0_NO_VENT
CONTROL_TRUTH[[6]] = CONTROL_ADVANCED_DISTRIBUTION_NO_VENT
CONTROL_TRUTH[[7]] = P_ADVANCED_0_VENT
CONTROL_TRUTH[[8]] = CONTROL_ADVANCED_DISTRIBUTION_VENT
###Put treatment simulation truth in a matrix
TREATMENT_TRUTH = as.list(rep(NA,8))
names(TREATMENT_TRUTH)=c("Probability of Death",
"Prob Vent at day 28 in survivors",
"Prob Vent for 0 days in survivors",
"Shift in Nonparametric density estimate of
 day 1-27 ventilation day in survivors",
"Prob of 0 day advanced respiratory support
 in non-ventilated surviving participants",
"Shift in Nonparametric density estimate of day 1-28
advanced respiratory days in non-ventilated surviving participants",
"Prob of 0 day advanced respiratory support in
 ventilated surviving participants",
"Shift in Nonparametric density estimate of day 1-28
 advanced respiratory days in ventilated surviving participants")
TREATMENT_TRUTH[[1]] = Prob_Death_Treatment
TREATMENT_TRUTH[[2]] = P_Vent_28_Treatment
TREATMENT_TRUTH[[3]] = P_Vent_0_Treatment
TREATMENT_TRUTH[[4]] = CHANGE_MEAN_VENTILATION_TREATMENT
TREATMENT_TRUTH[[5]] = P_ADVANCED_0_NO_VENT_Treatment
TREATMENT_TRUTH[[6]] = CHANGE_MEAN_ADVANCED_TREATMENT_NO_VENT
TREATMENT_TRUTH[[7]] = P_ADVANCED_0_VENT_Treatment
TREATMENT_TRUTH[[8]] = CHANGE_MEAN_ADVANCED_TREATMENT_VENT

###Setting up decision boundaries
#If NA, this means no interim decision at that look
N_LOOK = c(200,400,600,800)     ##Sample size at interim looks
cut_Wilcox = c(NA,.98,.95,.9)   ##Superiority cutoffs for Bayesian Wilcoxon
cut_gating = c(NA,.02,.02,.05)  ##Superiority cutoffs for Frequentist 1-sided Fisher test
SAFETY_BOUND = c(.1,NA,NA,NA)   ##Safety threshold for a mortality increase
Futility_BOUND = c(.5,.6,.7,NA) ##Bounds for stopping for futility based on Bayesian Wilcoxon
cut_AR = c(.2,.2,.2,.2)         ##Windows for AR truncation
Sim_ARDS_Win_Probability(CONTROL_TRUTH,CONTROL_VENT_DENSITY_NON_0_28,
CONTROL_ADVANCED_DISTRIBUTION_NO_VENT,
CONTROL_ADVANCED_DISTRIBUTION_VENT,
 TREATMENT_TRUTH,N_LOOK,
cut_Wilcox,cut_gating,SAFETY_BOUND, Futility_BOUND,cut_AR,  50)
}
