/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.algo;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.jet.math.tdcomplex.DComplex;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DComplexProperty {
    public static final DComplexProperty DEFAULT = new DComplexProperty(1.0E-9);
    public static final DComplexProperty ZERO = new DComplexProperty(0.0);
    public static final DComplexProperty TWELVE = new DComplexProperty(1.0E-12);
    protected double tolerance;

    private DComplexProperty() {
        this(1.0E-9);
    }

    public DComplexProperty(double d) {
        this.tolerance = Math.abs(d);
    }

    public void setTolerance(double d) {
        if (this == DEFAULT || this == ZERO || this == TWELVE) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(d);
    }

    public double tolerance() {
        return this.tolerance;
    }

    public boolean equals(final DComplexMatrix1D dComplexMatrix1D, final double[] dArray) {
        if (dComplexMatrix1D == null) {
            return false;
        }
        final double d = this.tolerance();
        boolean bl = false;
        int n = ConcurrencyUtils.getNumberOfThreads();
        int n2 = (int)dComplexMatrix1D.size();
        if (n > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n = Math.min(n, n2);
            Future[] futureArray = new Future[n];
            Boolean[] booleanArray = new Boolean[n];
            int n4 = n2 / n;
            for (n3 = 0; n3 < n; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n - 1 ? n2 : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] dArray3 = new double[2];
                        for (int i = n5; i < n6; ++i) {
                            double[] dArray2 = dComplexMatrix1D.getQuick(i);
                            dArray3[0] = Math.abs(dArray[0] - dArray2[0]);
                            dArray3[1] = Math.abs(dArray[1] - dArray2[1]);
                            if (!((dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray, dArray2, d))) {
                                dArray3[0] = 0.0;
                                dArray3[1] = 0.0;
                            }
                            if (!(dArray3[0] > d) && !(dArray3[1] > d)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        double[] dArray2 = new double[2];
        int n7 = 0;
        while ((long)n7 < dComplexMatrix1D.size()) {
            double[] dArray3 = dComplexMatrix1D.getQuick(n7);
            dArray2[0] = Math.abs(dArray[0] - dArray3[0]);
            dArray2[1] = Math.abs(dArray[1] - dArray3[1]);
            if (!((dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1]) && !DComplex.isEqual(dArray, dArray3, d))) {
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
            }
            if (dArray2[0] > d || dArray2[1] > d) {
                return false;
            }
            ++n7;
        }
        return true;
    }

    public boolean equals(final DComplexMatrix1D dComplexMatrix1D, final DComplexMatrix1D dComplexMatrix1D2) {
        if (dComplexMatrix1D == dComplexMatrix1D2) {
            return true;
        }
        if (dComplexMatrix1D == null || dComplexMatrix1D2 == null) {
            return false;
        }
        int n = (int)dComplexMatrix1D.size();
        if ((long)n != dComplexMatrix1D2.size()) {
            return false;
        }
        final double d = this.tolerance();
        boolean bl = false;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int n3;
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            Boolean[] booleanArray = new Boolean[n2];
            int n4 = n / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? n : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] dArray = new double[2];
                        for (int i = n5; i < n6; ++i) {
                            double[] dArray2 = dComplexMatrix1D.getQuick(i);
                            double[] dArray3 = dComplexMatrix1D2.getQuick(i);
                            dArray[0] = Math.abs(dArray3[0] - dArray2[0]);
                            dArray[1] = Math.abs(dArray3[1] - dArray2[1]);
                            if (!((dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                                dArray[0] = 0.0;
                                dArray[1] = 0.0;
                            }
                            if (!(dArray[0] > d) && !(dArray[1] > d)) continue;
                            return false;
                        }
                        return true;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    booleanArray[n3] = (Boolean)futureArray[n3].get();
                }
                bl = booleanArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    bl = bl && booleanArray[n3] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dComplexMatrix1D.getQuick(i);
            double[] dArray3 = dComplexMatrix1D2.getQuick(i);
            dArray[0] = Math.abs(dArray3[0] - dArray2[0]);
            dArray[1] = Math.abs(dArray3[1] - dArray2[1]);
            if (!((dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
            }
            if (!(dArray[0] > d) && !(dArray[1] > d)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(final DComplexMatrix2D dComplexMatrix2D, final double[] dArray) {
        if (dComplexMatrix2D == null) {
            return false;
        }
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D.columns();
        boolean bl = false;
        final double d = this.tolerance();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && dComplexMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, dComplexMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = dComplexMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? dComplexMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] dArray3 = new double[2];
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < dComplexMatrix2D.columns(); ++j) {
                                double[] dArray2 = dComplexMatrix2D.getQuick(i, j);
                                dArray3[0] = Math.abs(dArray[0] - dArray2[0]);
                                dArray3[1] = Math.abs(dArray[1] - dArray2[1]);
                                if (!((dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray, dArray2, d))) {
                                    dArray3[0] = 0.0;
                                    dArray3[1] = 0.0;
                                }
                                if (!(dArray3[0] > d) && !(dArray3[1] > d)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        double[] dArray2 = new double[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double[] dArray3 = dComplexMatrix2D.getQuick(i, j);
                dArray2[0] = Math.abs(dArray[0] - dArray3[0]);
                dArray2[1] = Math.abs(dArray[1] - dArray3[1]);
                if (!((dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1]) && !DComplex.isEqual(dArray, dArray3, d))) {
                    dArray2[0] = 0.0;
                    dArray2[1] = 0.0;
                }
                if (!(dArray2[0] > d) && !(dArray2[1] > d)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final DComplexMatrix2D dComplexMatrix2D, final DComplexMatrix2D dComplexMatrix2D2) {
        if (dComplexMatrix2D == dComplexMatrix2D2) {
            return true;
        }
        if (dComplexMatrix2D == null || dComplexMatrix2D2 == null) {
            return false;
        }
        int n = dComplexMatrix2D.rows();
        int n2 = dComplexMatrix2D.columns();
        if (n2 != dComplexMatrix2D2.columns() || n != dComplexMatrix2D2.rows()) {
            return false;
        }
        boolean bl = false;
        final double d = this.tolerance();
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && dComplexMatrix2D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, dComplexMatrix2D.rows());
            Future[] futureArray = new Future[n3];
            Boolean[] booleanArray = new Boolean[n3];
            int n5 = dComplexMatrix2D.rows() / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? dComplexMatrix2D.rows() : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] dArray = new double[2];
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < dComplexMatrix2D.columns(); ++j) {
                                double[] dArray2 = dComplexMatrix2D.getQuick(i, j);
                                double[] dArray3 = dComplexMatrix2D2.getQuick(i, j);
                                dArray[0] = Math.abs(dArray3[0] - dArray2[0]);
                                dArray[1] = Math.abs(dArray3[1] - dArray2[1]);
                                if (!((dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                                    dArray[0] = 0.0;
                                    dArray[1] = 0.0;
                                }
                                if (!(dArray[0] > d) && !(dArray[1] > d)) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    booleanArray[n4] = (Boolean)futureArray[n4].get();
                }
                bl = booleanArray[0];
                for (n4 = 1; n4 < n3; ++n4) {
                    bl = bl && booleanArray[n4] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double[] dArray2 = dComplexMatrix2D.getQuick(i, j);
                double[] dArray3 = dComplexMatrix2D2.getQuick(i, j);
                dArray[0] = Math.abs(dArray3[0] - dArray2[0]);
                dArray[1] = Math.abs(dArray3[1] - dArray2[1]);
                if (!((dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                    dArray[0] = 0.0;
                    dArray[1] = 0.0;
                }
                if (!(dArray[0] > d) && !(dArray[1] > d)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(final DComplexMatrix3D dComplexMatrix3D, final double[] dArray) {
        if (dComplexMatrix3D == null) {
            return false;
        }
        int n = dComplexMatrix3D.slices();
        final int n2 = dComplexMatrix3D.rows();
        final int n3 = dComplexMatrix3D.columns();
        boolean bl = false;
        final double d = this.tolerance();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && dComplexMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] dArray3 = new double[2];
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    double[] dArray2 = dComplexMatrix3D.getQuick(i, j, k);
                                    dArray3[0] = Math.abs(dArray[0] - dArray2[0]);
                                    dArray3[1] = Math.abs(dArray[1] - dArray2[1]);
                                    if (!((dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray, dArray2, d))) {
                                        dArray3[0] = 0.0;
                                        dArray3[1] = 0.0;
                                    }
                                    if (!(dArray3[0] > d) && !(dArray3[1] > d)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        double[] dArray2 = new double[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double[] dArray3 = dComplexMatrix3D.getQuick(i, j, k);
                    dArray2[0] = Math.abs(dArray[0] - dArray3[0]);
                    dArray2[1] = Math.abs(dArray[1] - dArray3[1]);
                    if (!((dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1] || dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1]) && !DComplex.isEqual(dArray, dArray3, d))) {
                        dArray2[0] = 0.0;
                        dArray2[1] = 0.0;
                    }
                    if (!(dArray2[0] > d) && !(dArray2[1] > d)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean equals(final DComplexMatrix3D dComplexMatrix3D, final DComplexMatrix3D dComplexMatrix3D2) {
        if (dComplexMatrix3D == dComplexMatrix3D2) {
            return true;
        }
        if (dComplexMatrix3D == null || dComplexMatrix3D2 == null) {
            return false;
        }
        boolean bl = false;
        int n = dComplexMatrix3D.slices();
        final int n2 = dComplexMatrix3D.rows();
        final int n3 = dComplexMatrix3D.columns();
        if (n3 != dComplexMatrix3D2.columns() || n2 != dComplexMatrix3D2.rows() || n != dComplexMatrix3D2.slices()) {
            return false;
        }
        final double d = this.tolerance();
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && dComplexMatrix3D.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n5;
            n4 = Math.min(n4, n);
            Future[] futureArray = new Future[n4];
            Boolean[] booleanArray = new Boolean[n4];
            int n6 = n / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = n5 * n6;
                final int n8 = n5 == n4 - 1 ? n : n7 + n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        double[] dArray = new double[2];
                        for (int i = n7; i < n8; ++i) {
                            for (int j = 0; j < n2; ++j) {
                                for (int k = 0; k < n3; ++k) {
                                    double[] dArray2 = dComplexMatrix3D.getQuick(i, j, k);
                                    double[] dArray3 = dComplexMatrix3D2.getQuick(i, j, k);
                                    dArray[0] = Math.abs(dArray3[0] - dArray2[0]);
                                    dArray[1] = Math.abs(dArray3[1] - dArray2[1]);
                                    if (!((dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                                        dArray[0] = 0.0;
                                        dArray[1] = 0.0;
                                    }
                                    if (!(dArray[0] > d) && !(dArray[1] > d)) continue;
                                    return false;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    booleanArray[n5] = (Boolean)futureArray[n5].get();
                }
                bl = booleanArray[0];
                for (n5 = 1; n5 < n4; ++n5) {
                    bl = bl && booleanArray[n5] != false;
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return bl;
        }
        double[] dArray = new double[2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n3; ++k) {
                    double[] dArray2 = dComplexMatrix3D.getQuick(i, j, k);
                    double[] dArray3 = dComplexMatrix3D2.getQuick(i, j, k);
                    dArray[0] = Math.abs(dArray3[0] - dArray2[0]);
                    dArray[1] = Math.abs(dArray3[1] - dArray2[1]);
                    if (!((dArray[0] == dArray[0] && dArray[1] == dArray[1] || dArray3[0] == dArray3[0] && dArray3[1] == dArray3[1] || dArray2[0] == dArray2[0] && dArray2[1] == dArray2[1]) && !DComplex.isEqual(dArray3, dArray2, d))) {
                        dArray[0] = 0.0;
                        dArray[1] = 0.0;
                    }
                    if (!(dArray[0] > d) && !(dArray[1] > d)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

