/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.matrix.tdcomplex.impl.DenseLargeDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.WrapperDoubleMatrix3D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_2D;
import edu.emory.mathcs.jtransforms.dht.DoubleDHT_3D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_2D;
import edu.emory.mathcs.jtransforms.dst.DoubleDST_3D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDoubleMatrix3D
extends WrapperDoubleMatrix3D {
    private static final long serialVersionUID = 1L;
    private double[][][] elements;
    private DoubleFFT_3D fft3;
    private DoubleDCT_3D dct3;
    private DoubleDST_3D dst3;
    private DoubleDHT_3D dht3;
    private DoubleFFT_2D fft2Slices;
    private DoubleDCT_2D dct2Slices;
    private DoubleDST_2D dst2Slices;
    private DoubleDHT_2D dht2Slices;

    public DenseLargeDoubleMatrix3D(int n, int n2, int n3) {
        block2: {
            super(null);
            try {
                this.setUp(n, n2, n3);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new double[n][n2][n3];
    }

    public void dct3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        this.dct3.forward(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dct2Slices(final boolean bl) {
        int n;
        if (this.dct2Slices == null) {
            this.dct2Slices = new DoubleDCT_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix3D.this.dct2Slices.forward(DenseLargeDoubleMatrix3D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.dct2Slices.forward(this.elements[i], bl);
            }
        }
    }

    public void dht3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        this.dht3.forward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dht2Slices() {
        int n;
        if (this.dht2Slices == null) {
            this.dht2Slices = new DoubleDHT_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix3D.this.dht2Slices.forward(DenseLargeDoubleMatrix3D.this.elements[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.dht2Slices.forward(this.elements[i]);
            }
        }
    }

    public void dst3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        this.dst3.forward(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void dst2Slices(final boolean bl) {
        int n;
        if (this.dst2Slices == null) {
            this.dst2Slices = new DoubleDST_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix3D.this.dst2Slices.forward(DenseLargeDoubleMatrix3D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.dst2Slices.forward(this.elements[i], bl);
            }
        }
    }

    public void fft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public DenseLargeDComplexMatrix3D getFft2Slices() {
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] dArray = denseLargeDComplexMatrix3D.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DenseLargeDoubleMatrix3D.this.rows; ++j) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[i][j], 0, dArray[i][j], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                            DenseLargeDoubleMatrix3D.this.fft2Slices.realForwardFull(dArray[i]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    System.arraycopy(this.elements[i][j], 0, dArray[i][j], 0, this.columns);
                }
                this.fft2Slices.realForwardFull(dArray[i]);
            }
        }
        return denseLargeDComplexMatrix3D;
    }

    public DenseLargeDComplexMatrix3D getFft3() {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] dArray = denseLargeDComplexMatrix3D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLargeDoubleMatrix3D.this.rows; ++j) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[i][j], 0, dArray[i][j], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    System.arraycopy(this.elements[i][j], 0, dArray[i][j], 0, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realForwardFull(dArray);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix3D;
    }

    public DenseLargeDComplexMatrix3D getIfft2Slices(final boolean bl) {
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] dArray = denseLargeDComplexMatrix3D.elements();
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DenseLargeDoubleMatrix3D.this.rows; ++j) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[i][j], 0, dArray[i][j], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                            DenseLargeDoubleMatrix3D.this.fft2Slices.realInverseFull(dArray[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    System.arraycopy(this.elements[i][j], 0, dArray[i][j], 0, this.columns);
                }
                this.fft2Slices.realInverseFull(dArray[i], bl);
            }
        }
        return denseLargeDComplexMatrix3D;
    }

    public DenseLargeDComplexMatrix3D getIfft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        DenseLargeDComplexMatrix3D denseLargeDComplexMatrix3D = new DenseLargeDComplexMatrix3D(this.slices, this.rows, this.columns);
        final double[][][] dArray = denseLargeDComplexMatrix3D.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            int n3 = this.slices / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? this.slices : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            for (int j = 0; j < DenseLargeDoubleMatrix3D.this.rows; ++j) {
                                System.arraycopy(DenseLargeDoubleMatrix3D.this.elements[i][j], 0, dArray[i][j], 0, DenseLargeDoubleMatrix3D.this.columns);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    System.arraycopy(this.elements[i][j], 0, dArray[i][j], 0, this.columns);
                }
            }
        }
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverseFull(dArray, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
        return denseLargeDComplexMatrix3D;
    }

    public double getQuick(int n, int n2, int n3) {
        return this.elements[n][n2][n3];
    }

    public void idct2Slices(final boolean bl) {
        int n;
        if (this.dct2Slices == null) {
            this.dct2Slices = new DoubleDCT_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix3D.this.dct2Slices.inverse(DenseLargeDoubleMatrix3D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.dct2Slices.inverse(this.elements[i], bl);
            }
        }
    }

    public void idht3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dht3 == null) {
            this.dht3 = new DoubleDHT_3D(this.slices, this.rows, this.columns);
        }
        this.dht3.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idht2Slices(final boolean bl) {
        int n;
        if (this.dht2Slices == null) {
            this.dht2Slices = new DoubleDHT_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix3D.this.dht2Slices.inverse(DenseLargeDoubleMatrix3D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.dht2Slices.inverse(this.elements[i], bl);
            }
        }
    }

    public void idct3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dct3 == null) {
            this.dct3 = new DoubleDCT_3D(this.slices, this.rows, this.columns);
        }
        this.dct3.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void idst2Slices(final boolean bl) {
        int n;
        if (this.dst2Slices == null) {
            this.dst2Slices = new DoubleDST_2D(this.rows, this.columns);
        }
        if ((n = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            DenseLargeDoubleMatrix3D.this.dst2Slices.inverse(DenseLargeDoubleMatrix3D.this.elements[i], bl);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int i = 0; i < this.slices; ++i) {
                this.dst2Slices.inverse(this.elements[i], bl);
            }
        }
    }

    public void idst3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.dst3 == null) {
            this.dst3 = new DoubleDST_3D(this.slices, this.rows, this.columns);
        }
        this.dst3.inverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void ifft3(boolean bl) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(n));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.realInverse(this.elements, bl);
        ConcurrencyUtils.setNumberOfThreads(n);
    }

    public void setQuick(int n, int n2, int n3, double d) {
        this.elements[n][n2][n3] = d;
    }

    public double[][][] elements() {
        return this.elements;
    }

    protected DoubleMatrix3D getContent() {
        return this;
    }

    public DoubleMatrix3D like(int n, int n2, int n3) {
        return new DenseLargeDoubleMatrix3D(n, n2, n3);
    }
}

