% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{rescale.variance}
\alias{rescale.variance}
\title{Noise standardisation for multivariate time series.}
\usage{
rescale.variance(x)
}
\arguments{
\item{x}{An input matrix of real values.}
}
\value{
A rescaled matrix of the same size is returned.
}
\description{
Each row of the input matrix is normalised by the estimated standard deviation computed through the median absolute deviation of increments.
}
\details{
This is an auxiliary function used by the \code{InspectChangepoint} package.
}
\examples{
x <- matrix(rnorm(40),5,8) * (1:5)
x.rescaled <- rescale.variance(x)
x.rescaled
}
