% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulIVS.R
\name{simulIVS}
\alias{simulIVS}
\title{Simulation of interval-valued responses to a questionnaire}
\usage{
simulIVS(
  n,
  k,
  w1 = 0.05,
  w2 = 0.35,
  w3 = 0.6,
  p = 2,
  q = 2,
  minimum = 1,
  maximum = 7
)
}
\arguments{
\item{n}{A single positive integer indicating the number of different
respondents that have answered to the questionnaire stored as
a unique \code{numeric} object.}

\item{k}{A single positive integer indicating the number of different items
included in the questionnaire stored as a unique \code{numeric}
object.}

\item{w1}{A single real number in \eqn{[0,1]} indicating the proportion
of observations that are generated in the first procedure
stored as a unique \code{numeric} object. By default,
\code{w1 = 0.05}.}

\item{w2}{A single real number in \eqn{[0,1]} indicating the proportion
of observations that are generated in the second procedure
saved as a unique \code{numeric} object. By default,
\code{w2 = 0.35}.}

\item{w3}{A single real number in \eqn{[0,1]} indicating the proportion
of observations that are generated in the third procedure
stored as a unique \code{numeric} object. By default,
\code{w3 = 0.60}.}

\item{p}{A single non-negative real number which indicates the first
parameter of a beta distribution. By default, \code{p = 2}.}

\item{q}{A single non-negative real number which indicates the second
parameter of a beta distribution. By default, \code{q = 2}.}

\item{minimum}{A single real number indicating the lower bound of the
interval-valued scale used saved as a unique \code{numeric}
value. By default, \code{minimum = 1}.}

\item{maximum}{A single real number indicating the upper bound of the
interval-valued scale used saved as a unique \code{numeric}
value. By default, \code{maximum = 7}.}
}
\value{
This function returns \eqn{n} interval-valued responses to each of \eqn{k}
items in a questionnaire contained in a \code{data.frame} with \eqn{n} rows
and \eqn{2k} columns with values in the reference interval
\eqn{[\code{minimum}, \code{maximum}]}. All interval-valued data's lower
bounds appear in the first \eqn{k} columns of the data.frame and then all
the corresponding upper bounds appear too.
}
\description{
This function allows to generate \eqn{n} interval-valued responses to each
of \eqn{k} items of a questionnaire. These interval-valued responses are
simulated mimicking the human behavior, considering three different
procedures as it is suggested by De la Rosa de Sáa \emph{et al}. (2015)
and Lubiano \emph{et al}. (2021).
}
\examples{
## Simulation some interval-valued responses to a questionnaire
## carried out under the following particular conditions
## Number of respondents: n = 100
## Number of items: k = 5
## Procedures proportions: (w1, w2, w3) = (0.10, 0.25, 0.65)
## Beta distribution parameters: (p, q) = (1, 7)
## Reference interval of interval-valued scales: [0, 10]
data <- simulIVS(100, 5, 0.10, 0.25, 0.65, 1, 7, 0, 10)
head(data)
}
\references{
\itemize{
\item De la Rosa de Sáa, S.; Gil, M.Á.; González-Rodríguez, G.;
López, M.T.; Lubiano M.A. (2015). Fuzzy rating scale-based
questionnaires and their statistical analysis, \emph{IEEE
Transactions on Fuzzy Systems}, 23(1):111-126.
\doi{10.1109/TFUZZ.2014.2307895}.
\item Lubiano, M.A.; García-Izquierdo, A.L.; Gil, M.Á. (2021). Fuzzy
rating scales: Does internal consistency of a measurement scale
benefit from coping with imprecision and individual differences in
psychological rating? \emph{Information Sciences}, 550:91-108.
\doi{10.1016/j.ins.2020.10.042}.
}
}
\author{
José García-García \email{garciagarjose@uniovi.es},\cr
with contributions from María Asunción Lubiano \email{lubiano@uniovi.es}
}
