% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-spr.R
\docType{methods}
\name{spr}
\alias{spr}
\alias{spr,IntervalData-method}
\alias{spr,IntervalList-method}
\alias{spr,IntervalMatrix-method}
\alias{spr<-}
\alias{spr<-,IntervalData-method}
\alias{spr<-,IntervalList-method}
\alias{spr<-,IntervalMatrix-method}
\title{Extract and replace the spreads of interval-valued objects}
\usage{
\S4method{spr}{IntervalData}(object)

\S4method{spr}{IntervalList}(object)

\S4method{spr}{IntervalMatrix}(object)

\S4method{spr}{IntervalData}(object) <- value

\S4method{spr}{IntervalList}(object) <- value

\S4method{spr}{IntervalMatrix}(object) <- value
}
\arguments{
\item{object}{A single nonempty compact interval or a list or matrix
with some intervals of this family, that is, an
\code{IntervalData}, \code{IntervalList}, or
\code{IntervalMatrix} instance.}

\item{value}{A \code{numeric} or \code{matrix} object with the new values
of the intervals spreads.}
}
\value{
On the one hand, \code{spr()} function returns the spreads of the intervals
contained in \code{IntervalData}, \code{IntervalList}, or
\code{IntervalMatrix} instances stored as a single \code{numeric} value, a
\code{numeric} vector, or a \code{matrix} object, respectively. On the other
hand, \code{spr<-} command does not return any value since it only allows to
replace the \code{spr} slot of the given interval-valued object.
}
\description{
This functions provides customized access to the \code{spr} slot of
\code{IntervalData}, \code{IntervalList}, and \code{IntervalMatrix} objects,
so their spreads can be extracted and replaced. This does not prevent to use
the @ accessor, but does not force others to know the implementation details.
}
\examples{
## Some mid() function examples

## With IntervalData
interval <- IntervalData(0, 1)

spr(interval)
spr(interval) <- 0.75
spr(interval)

## With IntervalList
list <- IntervalList(c(1, 3, 5), c(2, 4, 6))

spr(list[c(1, 3)])
spr(list[c(1, 3)]) <- c(1, 3)
spr(list[c(1, 3)])

## With IntervalMatrix
m <- IntervalMatrix(matrix(c(1, 5, 2, 6, 6, 2,
                             7, 3, 3, 4, 4, 5), 2, 6))

spr(m[1, 1])
spr(m[1, 1]) <- 2
spr(m[1, 1])

spr(m[1, 1:2])
spr(m[1, 1:2]) <- c(2, 3)
spr(m[1, 1:2])

spr(m[, c(1, 3)])
spr(m[, c(1, 3)]) <- matrix(1:4, 2, 2)
spr(m[, c(1, 3)])

}
\seealso{
For accessing \code{mid} slot of interval-valued objects, \code{\link{mid}()}
function can be used.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
