% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KMEANS.R
\name{KMEANS_FUNCTION}
\alias{KMEANS_FUNCTION}
\title{KMEANS_FUNCTION}
\usage{
KMEANS_FUNCTION(
  data,
  k,
  max_iter = 100,
  nstart = 25,
  distance_metric = "euclidean",
  scale_data = FALSE,
  impute_data = "mean"
)
}
\arguments{
\item{data}{A dataframe containing the numerical data to be clustered.}

\item{k}{The number of clusters to form.}

\item{max_iter}{The maximum number of iterations for the K-Means algorithm.}

\item{nstart}{The number of times to randomly initialize the centroids.}

\item{distance_metric}{The distance metric to use ('euclidean' or 'manhattan').}

\item{scale_data}{A boolean indicating whether the data should be normalized.}

\item{impute_data}{The imputation method for missing values ('mean', 'median', 'mode').}
}
\value{
A list containing the following elements:
- clusters: A vector indicating the cluster of each point.
- centers: The coordinates of the centroids of each cluster.
- additional_info: Additional information such as total distance and number of iterations.
}
\description{
This function implements the K-Means algorithm for data clustering.
It provides options for data preprocessing, such as normalization
and imputation of missing values.
}
\examples{
data(iris)
data_iris <- iris[, -5] # Exclude the species column
results <- KMEANS_FUNCTION(data_iris, k = 3)
print(results$clusters)
}
