% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powered_lm.R
\name{powered_lm}
\alias{powered_lm}
\title{Compute lm's post-hoc power}
\usage{
powered_lm(PRE = 0.04, PC = 1L, PA = 2L, n = 200L, sig_level = 0.05)
}
\arguments{
\item{PRE}{Proportional Reduction in Error.
PRE = The square of partial correlation.
Cohen (1988) suggested >=0.02, >=0.13, and >=0.26 as cut-off values of PRE for small,
medium, and large effect sizes, respectively.}

\item{PC}{Number of parameters of model C (compact model) without focal predictors of interest.
Non-integer \code{PC} would be converted to be an integer using \code{as.integer()}.}

\item{PA}{Number of parameters of model A (augmented model) with focal predictors of interest.
Non-integer \code{PA} would be converted to be an integer using \code{as.integer()}.
\code{as.integer(PA)} should be larger than \code{as.integer(PC)}.}

\item{n}{The current sample size. Non-integer \code{n} would be converted to be an integer using \code{as.integer()}.
Non-NULL \code{as.integer(n)} should be at least \code{as.integer(PA) + 1}.}

\item{sig_level}{Expected significance level for effects of focal predictors.}
}
\value{
Integer \code{n}, the F_test of \code{PRE} at the sample size \code{n} with
\code{df_A_C},
\code{df_A} (the df of the model A at the sample size \code{n}),
\code{F} (the F-test of \code{PRE} at the sample size \code{n}),
\code{p} (the p-value of F-test at the sample size \code{n}), and the post-hoc power analysis with
\code{lambda} (the non-centrality parameter of \code{F} at the sample size \code{n}),
and \code{power} (the post-hoc power at the sample size \code{n}).
}
\description{
Compute lm's post-hoc power
}
\examples{
powered_lm()
}
