% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOB.R
\name{getOB}
\alias{getOB}
\title{Retrieve Order Book Data from Kraken Exchange}
\usage{
getOB(pair, count = NULL)
}
\arguments{
\item{pair}{A character string specifying the trading pair (e.g., "ADAEUR").
This is a required parameter.}

\item{count}{An optional integer between 1 and 500 specifying the number
of orders to retrieve. Default is NULL.}
}
\value{
A data frame containing the order book data for
the requested trading pair,
with bid orders appearing first (sorted by price ascending)
followed by ask orders (sorted by price ascending).
}
\description{
This function fetches order book data from the Kraken API
for a specified trading pair.
}
\examples{
getOB("ADAEUR")
getOB("ADAEUR", count = 100)
}
