% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot_result}
\alias{plot_result}
\title{Plot the time series and change-points}
\usage{
plot_result(est_result, ...)
}
\arguments{
\item{est_result}{An S3 object of class 'result_no_nbd' or 'result_nbd' created by \code{\link[=get_breaks]{get_breaks()}}.}

\item{...}{Additional arguments.}
}
\value{
No return value. Presents the plot of the data and breaks.
}
\description{
Plot the time series and change-points
}
\details{
See \code{\link[=hdchange]{hdchange()}} for examples.
}
\examples{
\donttest{
# generate data
data_nbd <- sim_hdchange_nbd(n = 300,
p = 70,
nbd_info =
 list(
   (1:9), (2:31), (32:41), (42:70),
   (3:15), (16:35), (31:55)
 ),
sp_tp_break = rbind(c(2, 50), c(4, 150), c(2, 250)),
dist_info =
  list(dist = "t", dependence = "iid", param = 5),
jump_max = 1)

# construct nbd object
ts_nbd <- ts_hdchange(data_nbd,
window_size = 30,
m = 8,
h = 1,
N_rep = 999,
alpha = 1e-5,
quantiles = c(0.01, 0.05, 0.1),
nbd_info =
 list(
   (1:9), (2:31), (32:41), (42:70),
   (3:15), (16:35), (31:55)
 ))

# Estimate the time-stamps of the breaks
est_result_nbd <- hdchange(ts_nbd)

# Plot the results
plot_result(est_result_nbd, nbd_index = 2)
pairs <- est_result_nbd$nbd_and_stamps_pair
time_stamps <- pairs[pairs[, 1] == 2, 2]
axis(1,
  at = time_stamps,
  labels = c("break 1", "break 2")
)
title(main = "Change-points estimation for neibourhood 2")
}
}
