% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{valid_entities}
\alias{valid_entities}
\title{Filter entities to include only valid biomedical terms}
\usage{
valid_entities(
  entities,
  primary_term,
  primary_term_variations = NULL,
  validation_function = NULL,
  verbose = TRUE,
  entity_col = "entity",
  type_col = "entity_type"
)
}
\arguments{
\item{entities}{Data frame of entities to filter}

\item{primary_term}{The primary term to trust}

\item{primary_term_variations}{Vector of variations of the primary term to trust}

\item{validation_function}{Function to validate entities (default: is_valid_biomedical_entity)}

\item{verbose}{Logical; if TRUE, print status messages (default: TRUE)}

\item{entity_col}{Name of the column containing entity names (default: "entity")}

\item{type_col}{Name of the column containing entity types (default: "entity_type")}
}
\value{
A data frame of filtered entities
}
\description{
This function applies validation to ensure only legitimate biomedical entities
are included, while preserving trusted terms.
}
