% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{GMM_Wd}
\alias{GMM_Wd}
\title{GMM_Wd}
\usage{
GMM_Wd(m1, m2, S1, S2, w1 = NULL, w2 = NULL, S = NULL)
}
\arguments{
\item{m1}{matrix of means of first GMM}

\item{m2}{matrix of means of second GMM}

\item{S1}{array of covariance matrices of first GMM such that m1[i,] has covariance matrix S1[,,i]}

\item{S2}{array of covariance matrices of second GMM such that m2[i,] has covariance matrix S2[,,i]}

\item{w1}{(optional) vector of mixture weights of first GMM.}

\item{w2}{(optional) vector of mixture weights of second GMM.}

\item{S}{(optional) array of pre-computed sqrtm(sqrtm(S1[,,i]) \%*\% S2[,,j] \%*\% sqrtm(S1[,,i]))}
}
\value{
list of distance value d and optimal transport matrix ot
}
\description{
Compute 2-Wasserstein distance between two Gaussian mixture models
See: Delon J, Desolneux A. (2019) A Wasserstein-type distance in the space of Gaussian Mixture Models. hal-02178204v2
}
