\name{LSMrotate}
\alias{LSMrotate}

\title{
  Rotate the person and item latent space parameter matrices to an echeleon structure}
\description{
  This function rotates the person and item latent space parameter matrices to an echeleon structure.}

\usage{
LSMrotate(z, w, method="chol")
}
\arguments{
  \item{z}{ The \code{N} by \code{ndim_z} matrix of person coordinates \eqn{z_pr} to be rotated.}
  \item{w}{ The \code{nit} by \code{ndim_z} matrix of item coordinates \eqn{w_ir} to be rotated.}
  \item{method}{ Character string, either "stepwise" or "chol"}
  }

\details{
  \link{LSMfit} constrains the matrix of item coordinates \eqn{w_{ir}} to an echeleon structure in fitting the LSIRM to data. Therefore, to compare to results to other results (e.g., obtained using MCMC) or to the true values used to generate the data, it is necessary to rotate those other results/values to the same echeleon structure. This rotation can be performed using \code{LSMrotate}. Following Wansbeek & Meijer (2006), the function uses a Cholesky decomposition (method="chol", the default) which works for an arbirary number if latent space dimensions \code{R} (except 1). For method="stepwise", the function performs the explicit rotation steps by determining the angle of rotation as described in Molenaar and Jeon (submitted). This method is only implemented for 2 or 3 latent space dimensions.
}
\value{
  A list containing
   \item{ zt}{ The rotate matrix of \eqn{z_{pr}} parameters.}
   \item{ wt}{ The rotate matrix of \eqn{w_{ir}} parameters.}
   \item{ rotMat}{ The rotation matrix.}
}
\references{


Molenaar, D., & Jeon, M.J. (in press). Joint maximum likelihood estimation of latent space item response models. \emph{Psychometrika}.

Wansbeek, T. & Meijer, E. (2000). \emph{Measurement Error and Latent Variables in Econometrics}. Amsterdam: North-Holland.
}
\author{ Dylan Molenaar \email{d.molenaar@uva.nl}}

\seealso{
\code{\link{LSMfit}} to fit LSIRM models.
}
\examples{
 set.seed(1111)
 N=1000
 nit=20
 ndim_z=2

 #some true values not following the echeleon structure
 z=matrix(rnorm(N*ndim_z),N,ndim_z)
 w=matrix(rnorm(nit*ndim_z),nit,ndim_z)

 # simluate data using these true values
 dat_obj=LSMsim(N,nit,ndim_z,z=z,w=w)
 X=dat_obj$X

 #fit model
 results=LSMfit(X,2)

 #plot the parameter recovery results using the *unrotated* true values
 #spoiler: will look like nothing

 oldpar=par(mfrow=c(2,2))

 s_p=sign(cor(results$z,z))          # to correct for sign switches in the plots
 s_i=sign(cor(results$w,w))

 plot(s_p[1,1]*z[,1],results$z[,1]); abline(0,1)
 plot(s_p[2,2]*z[,2],results$z[,2]); abline(0,1)
 plot(s_i[1,1]*w[,1],results$w[,1]); abline(0,1)
 plot(s_i[2,2]*w[,2],results$w[,2]); abline(0,1)

 #plot the parameter recovery results using the *rotated* true values
 #spoiler: will look better

 zt=dat_obj$par$zt      # rotated true z, see ?LSMsim and ?LSMrotate
 wt=dat_obj$par$wt      # rotated true w

 s_p=sign(cor(results$z,zt))          # to correct for sign switches in the plots
 s_i=sign(cor(results$w,wt))

 plot(s_p[1,1]*zt[,1],results$z[,1]); abline(0,1)
 plot(s_p[2,2]*zt[,2],results$z[,2]); abline(0,1)
 plot(s_i[1,1]*wt[,1],results$w[,1]); abline(0,1)
 plot(s_i[2,2]*wt[,2],results$w[,2]); abline(0,1)

 par(oldpar)
}
\keyword{models}
\keyword{multivariate}
