% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{E_VandeGriend}
\alias{E_VandeGriend}
\title{Land Surface Emissivity according to Van de Griend and Owe 1993}
\usage{
E_VandeGriend(NDVI)
}
\arguments{
\item{NDVI}{SpatRaster object, NDVI calculated from remote sensing imagery}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Emissivity according to Van de Griend and Owe 1993
}
\examples{
NDVI <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(NDVI) = runif(10000, min=0.02, max=0.8)
E_VandeGriend(NDVI)
}
\references{
Van de Griend, A.A. and Owe, M., 1993. On the relationship between thermal emissivity and the normalized difference vegetation index for natural surfaces. International Journal of remote sensing, 14(6), pp.1119-1131.
}
