% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readtext.ij.r
\name{readtext.ij}
\alias{readtext.ij}
\title{File management}
\usage{
readtext.ij(path)
}
\arguments{
\item{path}{Path to the target directory}
}
\value{
A list of data frame of leaf area for each image
 \item{area}{Leaf area of the image (cm2)}
}
\description{
Read multiple tab-delimited text files with a leaf area and perimeter value (one text file for each original JPEG image file) generated by ImageJ.
}
\examples{
#prepare example files
data(leafdata)
tf <- paste(tempdir(), "/", sep = "")
for (i in 1:7){
	write.table(leafdata[[i]],paste(tf,names(leafdata)[i],sep=""),sep="\\t")
}

#list of files
list.files(tf)

readtext.ij(tf)

unlink(list.files(tf))
}
\seealso{
\code{\link{run.ij}}, \code{\link{resmerge.ij}}
}
\author{
Masatoshi Katabuchi \email{mattocci27@gmail.com}
}
