% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataProcessing.R
\name{batchdataProcessing}
\alias{batchdataProcessing}
\title{Process several mzXML files (peakpicking and isotope annotation) and create an 
msbatch for batch processing.}
\usage{
batchdataProcessing(
  files,
  metadata,
  polarity,
  dmzagglom = 15,
  drtagglom = 500,
  drtclust = 100,
  minpeak = c(5, 3),
  drtgap = 10,
  drtminpeak = 15,
  drtmaxpeak = c(100, 200),
  recurs = 5,
  sb = c(3, 2),
  sn = 2,
  minint = c(1000, 100),
  weight = c(2, 3),
  dmzIso = 10,
  drtIso = 5,
  parallel = FALSE,
  ncores,
  global_gb = getOption("LipidMS.future.globals.maxSizeGB", 24),
  verbose = TRUE
)
}
\arguments{
\item{files}{file paths of the mzXML files. Optional.}

\item{metadata}{csv file or data.frame with 3 columns: sample (samples named as the 
mzXML files), acquisitionmode (MS, DIA or DDA) and groups (i.e. blank, QC, sample).
DIA, DDA and MS files are allowed, but only DIA and DDA files will be used 
for lipid annotation.}

\item{polarity}{character value: negative or positive.}

\item{dmzagglom}{mz tolerance (in ppm) used for partitioning and clustering.}

\item{drtagglom}{rt window used for partitioning (in seconds).}

\item{drtclust}{rt window used for clustering (in seconds).}

\item{minpeak}{minimum number of measurements required for a peak.}

\item{drtgap}{maximum RT gap length to be filled (in seconds).}

\item{drtminpeak}{minimum RT width of a peak (in seconds). At least minpeak 
within the drtminpeak window are required to define a peak.}

\item{drtmaxpeak}{maximum RT width of a single peak (in seconds).}

\item{recurs}{maximum number of peaks within one EIC.}

\item{sb}{signal-to-base ratio.}

\item{sn}{signal-to-noise ratio.}

\item{minint}{minimum intensity of a peak.}

\item{weight}{weight for assigning measurements to a peak.}

\item{dmzIso}{mass tolerance for isotope matching.}

\item{drtIso}{time windows for isotope matching.}

\item{parallel}{logical.}

\item{ncores}{number of cores to be used in case parallel is TRUE.}

\item{global_gb}{numeric. Gigabytes to set as future.globals.maxSize **inside** the function.
Defaults to `getOption("LipidMS.future.globals.maxSizeGB", 24)`.}

\item{verbose}{print information messages.}
}
\value{
msbatch
}
\description{
Process several mzXML files (peakpicking and isotope annotation) and create an 
msbatch for batch processing.
}
\details{
This function executes 2 steps: 1) creates an msobject for each 
sample (using the \link{dataProcessing} function) and 2) sets an msbatch 
(\link{setmsbatch} function).

Numeric arguments accept one or two values for MS1 and MS2, respectively.
}
\examples{
\dontrun{
# if metadata is a data frame:
msbatch <- batchdataProcessing(metadata$sample, metadata, polarity = "positive",
dmzagglom = 25, drtagglom = 500, drtclust = 60, minpeak = c(5, 3),
drtgap = 5, drtminpeak = 20, drtmaxpeak = 100, recurs = 5, sb = c(3, 2),
sn = 2, minint = c(1000, 100), weight = 2, dmzIso = 10, drtIso = 5)

# if metadata is a csv file:
msbatch <- batchdataProcessing(metadata = "metadata.csv", polarity = "positive",
dmzagglom = 25, drtagglom = 500, drtclust = 60, minpeak = c(5, 3),
drtgap = 5, drtminpeak = 20, drtmaxpeak = 100, recurs = 5, sb = c(3, 2),
sn = 2, minint = c(1000, 100), weight = 2, dmzIso = 10, drtIso = 5)
}

}
\references{
Peak-picking algorithm has been imported from enviPick R-package:
https://cran.r-project.org/web/packages/enviPick/index.html
}
\seealso{
\link{dataProcessing} and \link{setmsbatch}
}
\author{
M Isabel Alcoriza-Balaguer <maribel_alcoriza@iislafe.es>
}
