#' Internal Logic Forest Functions
#'
#' This function is called by \code{predict.logforest}. It is not intended to be used independently of this function. 
#' It determined the proportion of logic regression trees within a logic forest that predict a class of one for new observations.  Additionally it returns predicted values for new observations.
#' @param predictmatrix matrix of predicted values
#' @param cutoff proportion of trees that predict class of one required to result in prediction of class of one 
#' 
#' @returns ans list of predicted values and proportion of trees that predict class of one
#' @export
#' @keywords internal

proportion.positive<-function(predictmatrix, cutoff)
{
  q<-nrow(predictmatrix)
  ntrees<-ncol(predictmatrix)
  status<-c()
  predict.pos<-c()
  for (a in 1:q)
  {
    number.diseasepositive<-sum(predictmatrix[a,])
    proportion.predictpositive<-number.diseasepositive/ntrees
    if (proportion.predictpositive >= cutoff)
      disease.status <- 1
    else if (proportion.predictpositive < cutoff)
      disease.status <- 0
    status<-append(status, disease.status)  
    predict.pos<-append(predict.pos, proportion.predictpositive)
  }
  predmat<-cbind(predict.pos, status)
  ans<-list(predmat=predmat)
}