% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loop_detection_functions.R
\name{find_loops_vset}
\alias{find_loops_vset}
\title{Loop detection for an ODE model at multiple sets of variables}
\usage{
find_loops_vset(
  fun,
  vset,
  ...,
  max_num_loops = 1e+05,
  compute_full_list = TRUE
)
}
\arguments{
\item{fun}{Function defining the ODE system, returns the vector \eqn{dx/dt}.
May depend on further parameters in \code{...}.}

\item{vset}{List of variable values at which the loops are determined.}

\item{...}{Further parameters except variable values to the function \code{fun},
none called \code{x}.}

\item{max_num_loops}{Positive numeric value indicating the maximal number
of loops that are reported in a loop list. Default: \eqn{10^5}.}

\item{compute_full_list}{Logical value indicating whether for each
Jacobian matrix with any different sign the loop list is computed (\code{TRUE},
default), or whether further checks are performed to ensure that loops
may be altered.}
}
\value{
A list with four entries:
\itemize{
\item \code{loop_rep} List of loop lists.
\item \code{loop_rep_index} Vector of integer numbers returning the index of the
loop list in loop_rep belonging to each entry in \code{vset}.
\item \code{jac_rep} List of signed Jacobian matrices.
\item \code{jac_rep_index} Vector of integer numbers returning the index of the
Jacobian matrix in jac_rep belonging to each entry in \code{vset}.
}
}
\description{
Determines loop lists for an ODE system given by a function
and at multiple sets of variables. Loop lists are reported if signs of
Jacobian matrix have changed.
}
\details{
The supplied function can take more arguments, but only the variables
are allowed to be named \code{x} (they can also be named differently).
The Jacobian matrices are computed for each of the variable
values defined in vset using the \code{\link[numDeriv]{jacobian}} function
from the \code{NumDeriv} package with option \code{method = 'complex'}, i.e. using a
complex-step approach.
If \code{compute_full_list = TRUE} (default), loop lists are not re-computed
for Jacobians that clearly do not allow for altered loop lists. This is
the case if no new regulation appear and only signs of regulations are
altered that are not member of any loop. Loop lists can still be
identical for different Jacobians, e.g. if two sign switches occur that
are both affecting the same loops.

If there is only one class of Jacobian matrix (i.e. the signs of the
Jacobian matrix are the same for all entries in \code{vset}), \code{loop_rep} and
\code{jac_rep} will have only one entry each. The number of entries for
\code{loop_rep_index} and \code{jac_rep_index} corresponds to the length of \code{vset}.
Only if \code{compute_full_list} is set to \code{FALSE}, \code{loop_rep} can contain
fewer elements than \code{jac_rep}, otherwise both have the same number of
elements.
}
\examples{
#default call to determine loops from an ODE model given by a function
#read in example functions
data("func_POSm4")
#the loaded function func_POSm4 takes arguments t, x, klin, knonlin
res_tab <- find_loops_vset(func_POSm4,vset=list(c(1,1,1,1)),t=1,
klin=c(1,2,0.5,1,2,0.1,3,2,3),knonlin=c(1,2))
#computed loop list:
res_tab$loop_rep[[1]] #or res_tab[[1]][[1]]

#determine loops from an ODE model over the course of a solution
#read in the example function defining the bacterial cell cycle
data("func_li08")
#kinetic parameter values are defined within the function
#read in a set of variable values (the solution of func_li08 with events)
data("li08_solution")
#transform the solution (columns: variables) to the correct list format
#and remove the time (first column)
li08_sol_list <- as.list(as.data.frame(t(li08_solution[,-1])))
res_tab <- find_loops_vset(func_li08,vset=li08_sol_list,t=1,
compute_full_list=FALSE)

}
