% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unanchored_maic_bootstrap.R
\name{unanchored_maic_bootstrap}
\alias{unanchored_maic_bootstrap}
\title{Conduct non-Anchored Matching-Adjusted Indirect Comparison (MAIC) and
Calculate Confidence Intervals (CIs) Using Bootstrap.}
\arguments{
\item{ipds}{A data frame containing individual patient data from the
intervention study, with baseline characteristic variables for matching.}

\item{psds}{A data frame containing pseudo data from the comparator study.}

\item{agds}{A data frame containing aggregate summary data from the
comparator study.}

\item{matching.list}{A character list with two elements giving the names
of variables for matching: the first is a vector of binary variables, and
the second is a vector of continuous variables. The variable names must
match the column names in \emph{ipds} and \emph{agds}. Use c() if a type is absent.}

\item{intervention.arm}{The name of the grouping column in the data frame
specified by \emph{ipds}, e.g., intervention.arm = TRT. The default is TRT.}

\item{comparator}{The name of the study column in the data frame specified
by \emph{agds}, e.g., comparator = STUDY. The default is STUDY.}

\item{comparator.study}{A character specifying the comparator study, which
must be quoted and cannot be empty (e.g., comparator.study = "Study XX-1").
This is the value of the study column in \emph{agds} set by the \emph{comparator}
parameter.}

\item{comparator.arm}{The name of the grouping column in the data frame
specified by \emph{agds}, e.g., comparator.arm = TRT. The default is TRT.}

\item{ipds.param.var}{The name of the column that specifies only a subset
of the \emph{ipds} to be used.}

\item{ipds.param}{A character specifying the subset of the rows to be used.
This is the value of the column set by the \emph{ipds.param.var}.}

\item{psds.param.var}{The name of the column that specifies only a specifyed
result of the \emph{psds} to be used.}

\item{psds.param}{A character specifying the subset of the rows to be used.
This is the value of the column set by the \emph{psds.param.var}.}

\item{time}{The name of the survival or follow up time column.}

\item{status}{The status indicator, normally 0 = event, 1 = censored. Can be
reseted using the \emph{event} parameter.}

\item{event}{A numeric value that represents the survival status, 0 = event,
1 = censored.}

\item{response}{The name of the response status column.}

\item{dtype}{Two options are available: "HR" and "OR". The default is "HR".}

\item{n.samples}{The number of bootstrap replicates.}

\item{CIw}{The numeric value specifying the width of the confidence interval,
with a default of 0.95.}

\item{digits}{Specify the number of decimal places for the output results.}

\item{...}{Refer to \link[boot:boot]{boot} for additional parameters.}
}
\value{
A list containing 2 objects.
First, a data frame containing the non-anchored matching-adjusted indirect
comparison results.
Second, a bootstrapping diagnostics histogram.
}
\description{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Two different methods for estimating a 95\% confidence interval (CI) from
the bootstrap samples were explored:
* Percentile CIs
* Bias-corrected and accelerated (BCa) CIs
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
cov <- list(
  c("ECOG", "SMK", "METBRAIN"),
  c("BMI", "DIAG")
)

results5 <- unanchored_maic_bootstrap(
  ipds = IPD,
  agds = AgD_bl,
  psds = pseudo,
  matching.list = cov,
  intervention.arm = TRT,
  comparator = STUDY,
  comparator.study = "Study XX-1",
  comparator.arm = TRT,
  time = AVAL, status = CNSR, event = 0,
  dtype = "HR",
  ipds.param.var = PARAMCD, ipds.param = "OS",
  psds.param.var = NULL, psds.param = NULL,
  n.samples = 1000
)

results5$results
results5$plot
}

}
