% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{get.closest.time}
\alias{get.closest.time}
\title{Create a dataset with a single time point from each study closest to specified time}
\usage{
get.closest.time(network, t = stats::median(network$data.ab$time))
}
\arguments{
\item{network}{An object of class \code{"mb.network"}.}

\item{t}{The time point at which}
}
\value{
A data frame in long format of responses at the closest time point to t in
each arm of each study.
}
\description{
Takes the closest time point from each arm in each study to a specified time (t) within an
\code{mb.network} object. Useful for network plots or exploring standard NMA.
}
\examples{

# Using the alogliptin dataset
network <- mb.network(alog_pcfb)

# Take a single follow-up time from each study...
# ...closest to 7
get.closest.time(network, t=7)

# ...closest to 20
get.closest.time(network, t=7)

# ...closest to the median follow-up across all studies
get.closest.time(network, t=26)

}
