% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selfcite_check.R
\name{selfcite_check}
\alias{selfcite_check}
\title{Calculates number of authors selfcitations against all references}
\usage{
selfcite_check(article_url, verbose = TRUE)
}
\arguments{
\item{article_url}{A valid MDPI article url}

\item{verbose}{Logical. If \code{TRUE}, informative messages will be printed during the function execution. Defaults to \code{TRUE}.}
}
\value{
A string (class: \code{data.frame})with the following columns:
\describe{
\item{selfcite}{The number of articles in references authored by any of the main article authors}
\item{total_ref}{Total number of references in the article}
}
}
\description{
Calculates number of authors selfcitations against all references
}
\examples{
\dontrun{
paper_url<-"https://www.mdpi.com/2223-7747/13/19/2785"
sc<-selfcite_check(paper_url)
}

}
