% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.MFT.R
\name{summary.MFT}
\alias{summary.MFT}
\title{summary.MFT}
\usage{
\method{summary}{MFT}(object, ...)
}
\arguments{
\item{object}{object of class MFT}

\item{...}{additional parameters}
}
\description{
Summary method for class 'mft'.
}
\examples{
# Rate change detection in Poisson process 
# with three change points (at t = 250, 600 and 680)
set.seed(0)
Phi1 <- runif(rpois(1,lambda=390),0,250)
Phi2 <- runif(rpois(1,lambda=380),250,600)
Phi3 <- runif(rpois(1,lambda=200),600,680)
Phi4 <- runif(rpois(1,lambda=400),680,1000)
Phi  <- sort(c(Phi1,Phi2,Phi3,Phi4)) 
mft  <- MFT.rate(Phi)
summary(mft)


}
\references{
Michael Messer, Marietta Kirchner, Julia Schiemann, Jochen Roeper, Ralph Neininger and Gaby Schneider (2014).
A multiple filter test for the detection of rate changes in renewal processes with varying variance. The Annals of Applied Statistics 8(4): 2027-67
<doi:10.1214/14-AOAS782>
}
\seealso{
\code{\link{MFT.rate}, \link{MFT.variance}, \link{MFT.mean}, \link{MFT.peaks}, \link{plot.MFT}}
}
\author{
Michael Messer, Stefan Albert, Solveig Plomer and Gaby Schneider
}
