% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-CRISPR2MF_SM.R
\name{cubeHomingDriveSM}
\alias{cubeHomingDriveSM}
\title{Inheritance Cube: CRISPR-SM (Clustered Regularly Interspaced Short Palindromic Repeats) with Small-Molecule Induction and 1 Resistance Allele and Maternal Deposition}
\usage{
cubeHomingDriveSM(
  cM = 1,
  cF = 1,
  dF = 0,
  chM = 0,
  chF = 0,
  dhF = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cM}{Male homing rate}

\item{cF}{Female homing rate}

\item{dF}{Female deposition homing rate}

\item{chM}{Male correct homing rate}

\item{chF}{Female correct homing rate}

\item{dhF}{Female correct deposition rate}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is a sex-specific version of CRISPR with small-molecule induced homing.
It assumes that the construct is on an autosome and there can be different
male/female homing rates. It also has maternal deposition, i.e., when the
male provides a W allele to a female with a H allele, some portion are cut
during oogenesis. Additionally, this cube is designed for small-molecule
induction, i.e., with the SM branch of MGDrivE. It allows the homing (H) allele
to be turned off into an O allele, which inherits stably, and so that all
offspring of H individuals are O until turned on with the spray.
If the maternal deposition parameters are zero (d* parameters), this is a normal
CRISPR drive.
}
