% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhqol_states_to_scores.R
\name{mhqol_states_to_scores}
\alias{mhqol_states_to_scores}
\title{Provides the scores of the MHQoL based on the textual input (as described in the manual)}
\usage{
mhqol_states_to_scores(
  states,
  ignore_invalid = FALSE,
  ignore_NA = FALSE,
  retain_old_variables = TRUE)
}
\arguments{
\item{states}{A dataframe, character vector or list containing the states of the MHQoL.
Must contain the following states: SI (Self-Image), IN (INdependence),
MO (MOod), RE (RElationships), DA (Daily Activities), PH (Physical Health), FU (FUture).}

\item{ignore_invalid}{If TRUE, the function will ignore missing states and continue processing.
If FALSE, the function will stop and throw an error.}

\item{ignore_NA}{If TRUE, the function will ignore NA values in the input data.
If FALSE, the function will stop and throw an error.}

\item{retain_old_variables}{If TRUE, the function will return the original states along with the new scores.
If FALSE, the function will only return the new scores.}
}
\value{
A dataframe containing the new scores based on the MHQoL manual.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
This function provides the scores of the MHQoL based on textual input as described in the manual of the MHQoL.
}
\examples{
# Example usage of the mhqol_scores function
# Get the MHQoL scores based on a character vector and do not retain old values
mhqol_states_to_scores(
  states = c(
    SI = "I think very positively about myself",
    IN = "I am very satisfied with my level of independence",
    MO = "I do not feel anxious, gloomy, or depressed",
    RE = "I am very satisfied with my relationships",
    DA = "I am very satisfied with my daily activities",
    PH = "I have no physical health problems",
    FU = "I am very optimistic about my future"
    ),
  retain_old_variables = FALSE
)

# Get the MHQoL scores based on a DataFrame and retain old values
# Define a sample DataFrame before using it
df <- data.frame(
  SI = "I think positively about myself",
  IN = "I am satisfied with my level of independence",
  MO = "I feel a little anxious, gloomy, or depressed",
  RE = "I am satisfied with my relationships",
  DA = "I am satisfied with my daily activities",
  PH = "I have some physical health problems",
  FU = "I am optimistic about my future"
)

# Get the MHQoL scores based on a DataFrame
mhqol_states_to_scores(states = df)


# Get the MHQoL scores based on a DataFrame and ignore missing states
mhqol_states_to_scores(states = df, ignore_invalid = TRUE)
}
\keyword{MHQoL}
\keyword{Scores}
\keyword{States}
