% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sg.R
\name{raw}
\alias{raw}
\title{Aggregate VNIR Spectra by Columns}
\usage{
raw(vnir.matrix)
}
\arguments{
\item{vnir.matrix}{A numeric matrix or data frame containing VNIR spectral data. Each row corresponds to a sample, 
and each column corresponds to a spectral band.}
}
\value{
A data frame containing the aggregated VNIR spectra with cleaned band names. 
The number of columns is reduced by averaging over every 10 bands and removing artifact-prone regions.
}
\description{
This function aggregates VNIR (Visible and Near-Infrared) spectral data by calculating the mean of every 10 columns 
while removing specific detector artifact regions (~1000nm and ~1800nm) and unwanted spectral bands.
}
\details{
The function removes columns corresponding to detector artifacts:
- rm1: bands 1–46
- rm2: bands 637–666
- rm3: bands 1437–1466
- rm4: bands 2127–2151
Additionally, columns 1:4, 64:66, 144:146, and 213:214 (after averaging) are removed.
}
\examples{
\donttest{
  raw_spectra <- raw(vnir_matrix)
}

}
