% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiCopParamDistLp.R
\name{BiCopParamDistLp}
\alias{BiCopParamDistLp}
\title{Compute the distance between 2 parametric copulas}
\usage{
BiCopParamDistLp(
  family,
  par,
  par_p,
  par2 = par,
  par2_p = par_p,
  family_p = family,
  p,
  type,
  maxEval = 0,
  truncVal = 0
)
}
\arguments{
\item{family}{family of the first copula.}

\item{par}{first parameter of the first copula.}

\item{par_p}{first parameter of the second copula.}

\item{par2}{second parameter of the first copula
(only useful for two-parameter families of copulas).}

\item{par2_p}{second parameter of the first copula
(only useful for two-parameter families of copulas).}

\item{family_p}{family of the second copula.}

\item{p}{determines the \eqn{L_p} distance that is used.}

\item{type}{type of the functions considered.
Can be \code{"cdf"} for the distance between the two cumulative distribution functions
or \code{"pdf"} for the distance between the two probability density functions.}

\item{maxEval}{maximum number of evaluation of the function to be integrated.
If 0, then no maximum limit is given. (Only used if \code{p < Inf}).}

\item{truncVal}{the distance is computed using the supremum or the integral
of the function on \eqn{[truncVal, 1 - truncVal]^2}.}
}
\value{
If \code{p < Inf}, it returns a list of four items
  \itemize{
    \item \code{distance} the value of the distance
    \item \code{integral} the value of the integral, which is
     the \eqn{p}-th power of the distance.
    \item \code{error} the estimated relative error of the integral
    \item \code{returnCode} the integer return code of the C routine
     called by \code{cubature::\link[cubature]{hcubature}()}.
     This should be 0 if there is no error.
  }
If \code{p = Inf}, it returns a list of two items
  \itemize{
    \item \code{distance} the maximum difference between the two copulas
    (respectively, between the two copula densities).
    \item \code{u_max} the point at which this difference is attained.
 }
}
\description{
This function uses the numerical integration procedure
\code{cubature::\link[cubature]{hcubature}()} to numerical integrate the distance between
the distribution or between the densities of two bivariate copulas.
}
\examples{
# Distance between the densities of a Gaussian copula with correlation 0.5
# and a Gaussian copula with correlation 0.2
BiCopParamDistLp(family = 1, par = 0.5, par_p = 0.2, p = 2, type = "cdf", maxEval = 10)
BiCopParamDistLp(family = 1, par = 0.5, par_p = 0.2, p = Inf, type = "cdf")

# Distance between the cdf of a Student copula
# with correlation 0.5 and 4 degrees of freedom
# and a Student copula with the same correlation but 20 degrees of freedom
BiCopParamDistLp(family = 2, par = 0.5, par_p = 0.5,
par2 = 5, par2_p = 20, p = 2, type = "pdf", maxEval = 10)

# Distance between the densities of a Gaussian copula with correlation 0.5
# and of a Student copula with correlation 0.5 and 15 degrees of freedom
BiCopParamDistLp(family = 1, par = 0.5, par_p = 0.5, par2_p = 15,
family_p = 2, p = 2, type = "pdf", maxEval = 10)

}
