% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qMNB.R
\name{qMNB}
\alias{qMNB}
\title{Randomized quantile residual}
\usage{
qMNB(par, formula, dataSet)
}
\arguments{
\item{par}{the maximum likelihood estimates.}

\item{formula}{The structure matrix of covariates of dimension n x p (in models that include an intercept x
should contain a column of ones).}

\item{dataSet}{data}
}
\value{
Randomized quantile Residuals
}
\description{
randomized quantile residual is available to assess possible departures
from the multivariate negative binomial model for fitting correlated data with overdispersion.
}
\details{
The randomized quantile residual (Dunn and Smyth, 1996), which
follow a standard normal distribution is used to assess departures from the multivariate negative binomial model.
}
\examples{

data(seizures)
head(seizures)

star <-list(phi=1, beta0=1, beta1=1, beta2=1, beta3=1)
mod <- fit.MNB(formula=Y ~ trt + period +
trt:period + offset(log(weeks)),star=star,dataSet=seizures,tab=FALSE)
par <- mod$par
names(par)<-c()

res.q <- qMNB(par=par,formula=Y ~ trt + period + trt:period +
offset(log(weeks)),dataSet=seizures)

plot(res.q,ylim=c(-3,4.5),ylab="Randomized quantile residual",
xlab="Index",pch=15,cex.lab = 1.5, cex = 0.6, bg = 5)
abline(h=c(-2,0,2),lty=3)
#identify(res.q)


data(alzheimer)
head(alzheimer)

star <- list(phi=10,beta1=2, beta2=0.2)
mod <- fit.MNB(formula = Y ~ trat, star = star, dataSet = alzheimer,tab=FALSE)

par<- mod$par
names(par) <- c()
re.q <- qMNB(par=par,formula = Y ~ trat, dataSet = alzheimer)
head(re.q)

}
\references{
\itemize{
\item Dunn, P. K. and Smyth, G. K. (1996). Randomized quantile residuals. Journal of Computational and Graphical
Statistics, 5, 236-244.
\item Fabio, L. C., Villegas, C., Carrasco, J. M. F., and de Castro, M. (2023).
Diagnostic tools for a multivariate negative binomial
model for fitting correlated data with overdispersion. Communications in
Statistics - Theory and Methods, 52, 1833–1853.
\item Fabio, L. C., Villegas, C., Mamun, A. S., and Carrasco, J. M. F. (2025).
Residual analysis for discrete correlated data in the multivariate approach.
Brazilian Journal of Biometrics, 43, e43728.
}
}
\author{
Jalmar M F Carrasco <carrascojalmar@gmail.com>,
Cristian M Villegas Lobos <master.villegas@gmail.com> and Lizandra C Fabio <lizandrafabio@gmail.com>
}
