% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_power_plan.R
\name{FactorialPowerPlan}
\alias{FactorialPowerPlan}
\title{sample size, power and effect size calculations for a factorial or fractional
factorial experiment}
\usage{
FactorialPowerPlan(
  alpha = 0.05,
  assignment = "unclustered",
  change_score_icc = NULL,
  cluster_size = NULL,
  cluster_size_sd = NULL,
  d_main = NULL,
  effect_size_ratio = NULL,
  icc = NULL,
  model_order = 1,
  nclusters = NULL,
  nfactors = 1,
  ntotal = NULL,
  power = NULL,
  pre_post_corr = NULL,
  pretest = "none",
  raw_coef = NULL,
  raw_main = NULL,
  sigma_y = NULL,
  std_coef = NULL
)
}
\arguments{
\item{alpha}{Two sided Type I error level for the test to be performed(default=0.05).}

\item{assignment}{One of three options: (default=unclustered)
        \enumerate{
           \item \dQuote{independent} or equivalently \dQuote{unclustered}
           \item \dQuote{within} or equivalently \dQuote{within_clusters}
           \item \dQuote{between} or equivalently \dQuote{between_clusters}
        }
Clusters in this context are preexisting units within which responses may
be dependent (e.g., clinics or schools).  A within-cluster experiment involves
randomizing individual members, while a between-cluster experiment involves
randomizing clusters as whole units (see Dziak, Nahum-Shani, and Collins, 2012)
<DOI:10.1037/a0026972>}

\item{change_score_icc}{The intraclass correlation of the change scores (posttest
minus pretest). Relevant only if assignment is between clusters and there is a pretest.}

\item{cluster_size}{The mean number of members in each cluster. Relevant only
if assignment is between clusters or within clusters.}

\item{cluster_size_sd}{Relevant only if assignment is between clusters. The standard deviation
of the number of members in each cluster (the default is 0
which means that the clusters are expected to be of equal size).}

\item{d_main}{Effect size measure: standardized mean difference raw_main/sigma_y.}

\item{effect_size_ratio}{Effect size measure: signal to noise ratio raw_coef^2/sigma_y^2.}

\item{icc}{Relevant only if assignment is between clusters or within clusters. The intraclass
correlation of the variable of interest in the absence of treatment.}

\item{model_order}{The highest order term to be included in the regression model in the planned analysis
(1=main effects, 2=two-way interactions, 3=three-way interactions, etc.); must be >= 1 and
<= nfactors (default=1).}

\item{nclusters}{The total number of clusters available (for between clusters or within clusters assignment).}

\item{nfactors}{The number of factors (independent variables) in the planned experiment(default=1).}

\item{ntotal}{The total sample size available (for unclustered assignment. For clustered assignment, use
\dQuote{cluster_size} and \dQuote{nclusters.}}

\item{power}{If specified: The desired power of the test. If returned in the output list: The expected power of the test.}

\item{pre_post_corr}{Relevant only if there is a pretest. The correlation between the pretest and the posttest.}

\item{pretest}{One of three options:
\enumerate{
\item \dQuote{no} or \dQuote{none} for no pretest.
\item \dQuote{covariate} for pretest to be entered as a covariate in the model.
  \item \dQuote{repeated} for pretest to be considered as a repeated measure.
}
The option \dQuote{yes} is also allowed and is interpreted as \dQuote{repeated.}
The option \dQuote{covariate} is not allowed if assignment is between clusters.  This
is because predicting power for covariate-adjusted cluster-level randomization is
somewhat complicated, although it can be approximated in practice by using the
formula for the repeated-measures cluster-level randomization (see simulations in Dziak,
Nahum-Shani, and Collins, 2012).}

\item{raw_coef}{Effect size measure: unstandardized effect-coded regression coefficient.}

\item{raw_main}{Effect size measure: unstandardized mean difference.}

\item{sigma_y}{The assumed standard deviation of the response variable after treatment, within each
treatment condition (i.e., adjusting for treatment but not adjusting for post-test).
This statement must be used if the effect size argument used is either \dQuote{raw_main} or
\dQuote{raw_coef}.}

\item{std_coef}{Effect size measure: standardized effect-coded regression coefficient raw_coef/sigma_y.}
}
\value{
A list with power, sample size and effect size.
}
\description{
There are three ways to use this function:

\enumerate{
\item Estimate power available from a given sample size and a given effect size.
\item Estimate sample size needed for a given power and a given effect size.
\item Estimate effect size detectable from a given power at a given sample size.
}

That is, there are three main pieces of information: power, sample size, and effect size.
The user provides two of them, and this function calculates the third.
}
\examples{
FactorialPowerPlan(assignment="independent",
                   model_order=2,
                   nfactors=5,
                   ntotal=300,
                   raw_main=3,
                   sigma_y=10)

FactorialPowerPlan(assignment="independent",
                   model_order=2,
                   nfactors=5,
                   ntotal=300,
                   pre_post_corr=.6,
                   pretest="covariate",
                   raw_main=3,
                   sigma_y=10)

}
