% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mqmf_utils.r
\name{printV}
\alias{printV}
\title{printV returns a vector cbinded to 1:length(invect)}
\usage{
printV(invect, label = c("index", "value"))
}
\arguments{
\item{invect}{the input vector to be more easily visualized, this can be
numbers, characters, or logical. If logical the TRUE and FALSE are
converted to 1's and 0's}

\item{label}{the column labels for the vector, default is 'index' and 'value'}
}
\value{
a dataframe containing the vector 1:length(invect), and invect.
}
\description{
printV takes an input vector and generates another vector of
    numbers 1:length(invect) which it cbinds to itself. This is primarily
    useful when trying to print out a vector which can be clumsy to read when
    print across the screen. applying printV leads to a single vector being
    printed down the screen
}
\examples{
vec <- rnorm(10,mean=20,sd=2)
printV(vec)
vec <- letters
printV(vec)
vec <- c(TRUE,TRUE,TRUE,FALSE,FALSE,TRUE,TRUE,FALSE,FALSE,TRUE,TRUE)
printV(vec,label=c("index","logicstate"))
}
