% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spm.r
\name{simpspm}
\alias{simpspm}
\title{simpspm calculates only the predicted log(CE) for an SPM}
\usage{
simpspm(
  pars,
  indat,
  schaefer = TRUE,
  year = "year",
  cats = "catch",
  index = "cpue"
)
}
\arguments{
\item{pars}{the parameters of the SPM are either c(r,K,Binit,sigma),
or c(r, K, sigma), the sigma is required in both cases. Binit is 
required if the fishery data starts after the stock has been
depleted. Each parameter must be log-transformed for improved 
model stability and is back-transformed inside simpspm.}

\item{indat}{the data which needs to include year, catch, and cpue.}

\item{schaefer}{a logical value determining whether the spm is to be 
a simple Schaefer model (p=1) or approximately a Fox model 
(p=1e-08). The default is TRUE = Schaefer model}

\item{year}{column name within indat containing the years, default='year'}

\item{cats}{column name within indat containing the catches, default='catch'}

\item{index}{column name within indat containing the cpue. default='cpue'}
}
\value{
a vector of length nyrs of the predicted log(cpue)
}
\description{
simpspm calculates only the predicted log(CPUE) for a 
    Surplus Production Model (SPM). It sets the Polacheck et al, 1993 
    parameter 'p' depending on the schaefer boolean argument, and 
    this determines the asymmetry of the production curve. Note p is
    set not estimated. If p = 1.0 then the SPM is the Schaefer model, 
    if it is 1e-8 it approximates the Fox model. The output of 
    log(CPUE) is to simplify the use of log-normal residual errors or 
    likelihoods. This function is designed for data consisting of 
    only a single cpue time-series. simpspm must have at least three 
    parameters, including the sigma, even if sum-of-squared residuals 
    is used as a minimizer, then sigma would just float. The column 
    names for year, catch and cpue are included to facilitate ease
    of use with other data sets.
}
\examples{
 data(abdat)
 param <- log(c(r=0.4,K=9400,Binit=3400,sigma=0.05))
 predCE <- simpspm(pars=param,indat=abdat)
 cbind(abdat,exp(predCE))
}
