% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSCsimtester.R
\name{rootedTriple}
\alias{rootedTriple}
\title{Compare expected and sample frequencies of topological rooted triples.}
\usage{
rootedTriple(
  stree,
  popSizes,
  gtSample,
  taxon1,
  taxon2,
  taxon3,
  subsampleSize = FALSE
)
}
\arguments{
\item{stree}{An object of class \code{phylo} containing a rooted metric species tree.
Edge lengths are in number of generations.}

\item{popSizes}{An ordered list containing constant population sizes for each species tree edge, for a haploid organism.
Sizes should be doubled for diploids. If \code{stree} has k edges, then \code{popSizes} must have k+1 elements,
with the final entry for the population ancestral to the root.}

\item{gtSample}{An object of class \code{multiPhylo} holding a sample of gene trees from a simulation.
Taxon labels on gene trees must be identical to those on \code{stree}.}

\item{taxon1}{A string specifying one taxon on \code{stree}.}

\item{taxon2}{A string specifying a second taxon on \code{stree}, distinct from \code{taxon1}.}

\item{taxon3}{A string specifying a third taxon on \code{stree}, distinct from \code{taxon1}, \code{taxon2}.}

\item{subsampleSize}{A positive integer or \code{FALSE}, giving size of subsamples of \code{gtSample} to analyze.}
}
\value{
If \code{subsampleSize} is \code{FALSE}, returns an object of type \code{rootedTripleOutput}
which contains a table \code{$TripletCounts} of empirical and expected rooted triple counts,
a p-value \code{$pv} from the Chi-squared test, and a column \code{$InternalEdge} of estimated and exact internal edge lengths.
If \code{subsampleSize} is \code{TRUE}, returns \code{NULL} but produces several plots.
}
\description{
For a given species tree with population sizes, compares the expected frequencies
of rooted triples to empirical frequencies in a sample of gene trees, using Chi-squared tests with 2 d.f.
The exact and estimated internal branch length (in coalescent units) of the rooted triple
in the species tree are also computed for comparison.  A single test can be performed
on the entire gene tree sample, or multiple tests on subsamples.
}
\details{
When \code{subsampleSize} is \code{FALSE} the Chi-squared test is performed using all
gene trees in \code{gtSample}. Results are reported in tabular form in the console.

When \code{subsampleSize} is positive, the  \code{N} trees in \code{gtSample}
will be partitioned into \code{N/subsampleSize} subsamples, with a Chi-squared test
performed for each. Histograms are plotted for (1) the p-values for the Chi-squared tests on
subsamples, and (2) subsample estimates of the internal branch length for the rooted triple on the
species tree, with the true value marked.

Three distinct taxon names must be supplied, all of which must occur on \code{stree}
and in each of the gene trees in the sample.
}
\examples{
\donttest{stree=read.tree(text="((((a:10000,b:10000):10000,c:20000):10000,d:30000):10000,e:40000);")
pops=c(15000,25000,10000,1,1,1,1,1,12000)
gts=read.tree(file=system.file("extdata","genetreeSample",package="MSCsimtester"))
rootedTriple(stree,pops,gts,"a","b","c")
rootedTriple(stree,pops,gts,"a","b","c",1000) }
}
\seealso{
\code{\link{plotEdgeOrder}}, \code{\link{plotPops}}
}
