% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStability.R
\name{plotStability}
\alias{plotStability}
\title{Plot stability}
\usage{
plotStability(MUVRrdCVclassObject, model = "min", VAll, nVarLim, missLim)
}
\arguments{
\item{MUVRrdCVclassObject}{MUVR class object or rdCV object}

\item{model}{'min' (default), 'mid' or 'max'}

\item{VAll}{Option of specifying which variables (i.e. names) to consider as reference set.
Defaults to variables selected from the `model` of the `MUVRrdCVclassObject`}

\item{nVarLim}{Option of specifying upper limit for number of variables}

\item{missLim}{Option of specifying upper limit for number of misclassifications}
}
\value{
Plot of number of variables, proportion of variables overlapping with reference and prediction accuracy (Q2 for regression; MISS otherwise) as a function of number of repetitions.
}
\description{
Plot stability of selected variables and prediction fitness as a function of number of repetitions.
}
\examples{
\donttest{
data("freelive2")
nRep <- 2
nOuter <- 4
varRatio <-0.6
regrModel <- MUVR2(X = XRVIP2,
                   Y = YR2,
                   nRep = nRep,
                  nOuter = nOuter,
                   varRatio = varRatio,
                   method = "PLS",
                   modReturn = TRUE)
plotStability(regrModel, model = "min")
}
}
