% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{calculate_EPT}
\alias{calculate_EPT}
\title{This index is calculated based on the number of families belonging to three macroinvertebrate orders: Ephemeroptera, Plecoptera and Trichoptera.}
\usage{
calculate_EPT(
  dataset,
  EPT_families = c("Ameletidae", "Ametropodidae", "Ameletopsidae", "Arthropleidae",
    "Acanthametropodidae", "Baetidae", "Baetiscidae", "Behningiidae", "Caenidae",
    "Coloburiscidae", "Ephemerellidae", "Ephemeridae", "Heptageniidae", "Isonychiidae",
    "Leptophlebiidae", "Leptohyphidae", "Metretopodidae", "Neoephemeridae",
    "Oligoneuriidae", "Palingeniidae", "Prosopistomatidae", "Polymitarcyidae",
    "Potamanthidae", "Siphlonuridae", "Tricorythidae", "Oniscigastridae",
    "Austroperlidae", "Capniidae", "Chloroperlidae", "Diamphipnoidae", 
    
    "Eustheniidae", "Gripopterygidae", "Leuctridae", "Nemouridae", "Notonemouridae",
    "Peltoperlidae", "Perlidae", "Perlodidae", "Pteronarcyidae", "Taeniopterygidae",
    "Styloperlidae", "Anomalopsychidae", "Antipodoeciidae", "Apataniidae",
    "Arctopsychidae", "Atriplectididae", "Beraeidae", "Brachycentridae",
    "Calamoceratidae", "Chathamiidae", "Dipseudopsidae", "Ecnomidae", "Glossosomatidae",
    "Goeridae", "Helicopsychidae", "Hydrobiosidae", "Hydropsychidae", "Hydroptilidae",
    "Kalophryganeidae", "Kokiriidae", 
     "Lepidostomatidae", "Leptoceridae",
    "Limnephilidae", "Molannidae", "Odontoceridae", "Oeconesidae", "Philopotamidae",
    "Philorheithridae", "Phryganeidae", "Polycentropodidae", "Psychomyiidae",
    "Pisuliidae", "Plectrotarsidae", "Rhyacophilidae", "Stenopsychidae",
    "Sericostomatidae", "Tasimiidae", "Uenoidae", "Xiphocentronidae"),
  print_results = TRUE
)
}
\arguments{
\item{dataset}{Data set must have predefined column names: Family, Abundace and Site}

\item{EPT_families}{families that belong  to EPT are given by default}

\item{print_results}{A logical value that determines whether or not to print the results. Defaults to TRUE.}
}
\value{
values from 0-10,
}
\description{
This index is calculated based on the number of families belonging to three macroinvertebrate orders: Ephemeroptera, Plecoptera and Trichoptera.
}
\examples{
Site= c("L1", "L2", "L2")
Family=c("Capniidae",  "Aeshnidae", "Chloroperlidae")
test <- data.frame( Family, Site)
calculate_EPT(test)
}
\references{
Hilsenhoff, W.L. 1987. An Improved Biotic Index of Organic Stream Pollution. Michigan Entomology Society. 20(11):9-13

Lenat, D.R. 1988. Water quality assessment using a qualitative collection method for benthic macroinvertebrates. J.N. Am. Benthological Soc. 7: 222-233.

MacDonald, D.D., Ingersoll, C.G., and Berger, T.A., 2000, Development and evaluation of consensus-based sediment quality guidelines for freshwater ecosystems: Archives of Environmental Contamination and Toxicology, v. 39, p. 20-31.

Weber, C.I., ed., 1973, Biological field and laboratory methods for measuring the quality of surface waters and effluents: Cincinnati, Ohio, U.S. Environmental Protection Agency, EPA-670/4-73-001.

Lenat DR, Penrose DL. History of the EPT taxa richness metric. Bulletin North American Benthological Society. 1996;12:279–290. https://doi.org/10.2307/1467463.
}
