% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madantextnetwork.r
\name{FUNbigrams}
\alias{FUNbigrams}
\title{Extract Bigram Information and Count Frequency}
\usage{
FUNbigrams(tf.bigrams)
}
\arguments{
\item{tf.bigrams}{A data frame with bigram terms and their frequency.}
}
\value{
A tibble data frame where each row represents a unique bigram from
the input data. The data frame contains three columns: 'word1' and
'word2' representing the individual words in the bigram, and 'weight'
representing the frequency of the bigram in the corpus. This structure
facilitates further analysis of the bigram relationships and their
occurrences.
}
\description{
This function processes a data frame containing bigrams and their frequency,
and creates a new data frame with separated words and their frequencies.
}
\examples{
tf_bigrams <- data.frame(term = c("hello_world", "shiny_app"),
                         term_freq = c(3, 2))
bigram_info <- FUNbigrams(tf_bigrams)
}
