% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-generics.R, R/dummyManagedProvider.R
\name{runDockerWorkerContainers}
\alias{runDockerWorkerContainers}
\alias{runDockerWorkerContainers,DummyManagedProvider-method}
\title{Run the worker container}
\usage{
runDockerWorkerContainers(
  provider,
  cluster,
  container,
  hardware,
  workerNumber,
  verbose
)

\S4method{runDockerWorkerContainers}{DummyManagedProvider}(
  provider,
  cluster,
  container,
  hardware,
  workerNumber,
  verbose
)
}
\arguments{
\item{provider}{S4 \code{CloudProvider} object. The service provider.}

\item{cluster}{S4 \code{DockerCluster} object.}

\item{container}{S4 \code{DockerContainer} Object. The worker container.}

\item{hardware}{S4 \code{DockerHardware} Object. The worker hardware.}

\item{workerNumber}{Integer. The number of workers needs to be run.}

\item{verbose}{Integer. The verbose level, default 1.}
}
\value{
A character vector with each element corresponding to a worker container.
The length must be equal to \code{workerNumber}
}
\description{
Run the workers and return a character vector of the worker handles. Each handle must
correspond to a container. The handle can be duplicated if multiple workers share the
same container. There is no default method for this generic.
}
\section{Functions}{
\itemize{
\item \code{runDockerWorkerContainers,DummyManagedProvider-method}: The method for the dummy managed provider
}}

