% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eigen.HMM_fit.R
\name{Eigen.HMM_fit}
\alias{Eigen.HMM_fit}
\title{Fitting Parsimonious Hidden Markov Models for Matrix-Variate Longitudinal Data}
\usage{
Eigen.HMM_fit(
  Y,
  init.par = NULL,
  tol = 0.001,
  maxit = 500,
  nThreads = 1,
  verbose = FALSE
)
}
\arguments{
\item{Y}{An array with dimensions \code{p} x \code{r} x \code{num} x \code{t}, where \code{p} is the number of
variables in the rows of each data matrix, \code{r} is the number of variables in the columns of each
data matrix, \code{num} is the number of data observations, and \code{t} is the number of time points.}

\item{init.par}{A list of initial values for starting the algorithms, as generated by the \code{Eigen.HMM_init()} function.}

\item{tol}{A numeric value specifying the tolerance level for the ECM algorithms' convergence.}

\item{maxit}{A numeric value specifying the maximum number of iterations for the ECM algorithms.}

\item{nThreads}{A positive integer indicating the number of cores to use for parallel processing.}

\item{verbose}{A logical value indicating whether to display the running output.}
}
\value{
A list containing the following elements:
\item{results}{A list of the results from the fitted models.}
\item{c.time}{A numeric value providing information on the computational time required to fit all models for each state.}
\item{models}{A data frame listing the models that were fitted.}
}
\description{
Fits parsimonious Hidden Markov Models for matrix-variate longitudinal data using ECM algorithms.
The models are based on the matrix-variate normal, matrix-variate t, and matrix-variate contaminated normal distributions.
Parallel computing is implemented and highly recommended for faster model fitting.
}
\examples{
data(simData)
Y <- simData$Y
init <- Eigen.HMM_init(Y = Y, k = 2, density = "MVT", mod.row = "EEE", mod.col = "EE", nstartR = 10)
fit <- Eigen.HMM_fit(Y = Y, init.par = init, nThreads = 1)
}
