% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.bestM.R
\name{extract.bestM}
\alias{extract.bestM}
\title{Selection of the best fitting model(s)}
\usage{
extract.bestM(results, top = 1)
}
\arguments{
\item{results}{The output of the \code{Eigen.HMM_fit()} function.}

\item{top}{Integer. Specifies the number of top-ranked models to display based on the Bayesian Information Criterion (BIC).}
}
\value{
A list containing the required best fitting model(s).
}
\description{
This functions extracts the best fitting model(s) according to the Bayesian information criterion (BIC).
}
\examples{
data(simData)
Y <- simData$Y
init <- Eigen.HMM_init(Y = Y, k = 2, density = "MVT", mod.row = "EEE", mod.col = "EE", nstartR = 10)
fit <- Eigen.HMM_fit(Y = Y, init.par = init, nThreads = 1)
win <- extract.bestM(results = fit, top = 1)
}
